e
    end

    # Returns all external incompatibilities in this incompatibility's
    # derivation graph
    def external_incompatibilities
      if conflict?
        [
          cause.conflict,
          cause.other
        ].flat_map(&:external_incompatibilities)
      else
        [this]
      end
    end

    def to_s
      return @custom_explanation if @custom_explanation

      case cause
      when :root
        "(root dependency)"
      when :dependency
        "#{terms[0].to_s(allow_every: true)} depends on #{terms[1].invert}"
      when Bundler::PubGrub::Incompatibility::InvalidDependency
        "#{terms[0].to_s(allow_every: true)} depends on unknown package #{cause.package}"
      when Bundler::PubGrub::Incompatibility::NoVersions
        "no versions satisfy #{cause.constraint}"
      when Bundler::PubGrub::Incompatibility::ConflictCause
        if failure?
          "version solving has failed"
        elsif terms.length == 1
          term = terms[0]
          if term.positive?
            if term.constraint.any?
              "#{term.package} cannot be used"
            else
              "#{term.to_s(allow_every: true)} cannot be used"
            end
          else
            "#{term.invert} is required"
          end
        else
          if terms.all?(&:positive?)
            if terms.length == 2
              "#{terms[0].to_s(allow_every: true)} is incompatible with #{terms[1]}"
            else
              "one of #{terms.map(&:to_s).join(" or ")} must be false"
            end
          elsif terms.all?(&:negative?)
            if terms.length == 2
              "either #{terms[0].invert} or #{terms[1].invert}"
            else
              "one of #{terms.map(&:invert).join(" or ")} must be true";
            end
          else
            positive = terms.select(&:positive?)
            negative = terms.select(&:negative?).map(&:invert)

            if positive.length == 1
              "#{positive[0].to_s(allow_every: true)} requires #{negative.join(" or ")}"
            else
              "if #{positive.join(" and ")} then #{negative.join(" or ")}"
            end
          end
        end
      else
        raise "unhandled cause: #{cause.inspect}"
      end
    end

    def inspect
      "#<#{self.class} #{to_s}>"
    end

    def pretty_print(q)
      q.group 2, "#<#{self.class}", ">" do
        q.breakable
        q.text to_s

        q.breakable
        q.text " caused by "
        q.pp @cause
      end
    end

    private

    def cleanup_terms(terms)
      terms.each do |term|
        raise "#{term.inspect} must be a term" unless term.is_a?(Term)
      end

      if terms.length != 1 && ConflictCause === cause
        terms = terms.reject do |term|
          term.positive? && Package.root?(term.package)
        end
      end

      # Optimized simple cases
      return terms if terms.length <= 1
      return terms if terms.length == 2 && terms[0].package != terms[1].package

      terms.group_by(&:package).map do |package, common_terms|
        common_terms.inject do |acc, term|
          acc.intersect(term)
        end
      end
    end
  end
end
                                                                                                                                                                                                                                                                                                                                                                                                                                                        gems/gems/bundler-2.4.19/lib/bundler/vendor/pub_grub/lib/pub_grub/version_range.rb                  0000644                 00000020257 15040313375 0023671 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       gems/gems/bundler-2.4.19/lib/bundler/vendor/pub_grub/lib/pub_grub/incompatibility.rb                0000644                 00000010110 15040313375 0024213 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       def hash
        [].hash
      end

      def intersects?(_)
        false
      end

      def intersect(other)
        self
      end

      def allows_all?(other)
        other.empty?
      end

      def include?(_)
        false
      end

      def any?
        false
      end

      def to_s
        "(no versions)"
      end

      def ==(other)
        other.class == self.class
      end

      def invert
        VersionRange.any
      end

      def select_versions(_)
        []
      end
    end

    EMPTY = Empty.new
    Empty.singleton_class.undef_method(:new)

    def self.empty
      EMPTY
    end

    def self.any
      new
    end

    def initialize(min: nil, max: nil, include_min: false, include_max: false, name: nil)
      @min = min
      @max = max
      @include_min = include_min
      @include_max = include_max
      @name = name
    end

    def hash
      @hash ||= min.hash ^ max.hash ^ include_min.hash ^ include_max.hash
    end

    def eql?(other)
      if other.is_a?(VersionRange)
        !other.empty? &&
          min.eql?(other.min) &&
          max.eql?(other.max) &&
          include_min.eql?(other.include_min) &&
          include_max.eql?(other.include_max)
      else
        ranges.eql?(other.ranges)
      end
    end

    def ranges
      [self]
    end

    def include?(version)
      compare_version(version) == 0
    end

    # Partitions passed versions into [lower, within, higher]
    #
    # versions must be sorted
    def partition_versions(versions)
      min_index =
        if !min || versions.empty?
          0
        elsif include_min?
          (0..versions.size).bsearch { |i| versions[i].nil? || versions[i] >= min }
        else
          (0..versions.size).bsearch { |i| versions[i].nil? || versions[i] > min }
        end

      lower = versions.slice(0, min_index)
      versions = versions.slice(min_index, versions.size)

      max_index =
        if !max || versions.empty?
          versions.size
        elsif include_max?
          (0..versions.size).bsearch { |i| versions[i].nil? || versions[i] > max }
        else
          (0..versions.size).bsearch { |i| versions[i].nil? || versions[i] >= max }
        end

      [
        lower,
        versions.slice(0, max_index),
        versions.slice(max_index, versions.size)
      ]
    end

    # Returns versions which are included by this range.
    #
    # versions must be sorted
    def select_versions(versions)
      return versions if any?

      partition_versions(versions)[1]
    end

    def compare_version(version)
      if min
        case version <=> min
        when -1
          return -1
        when 0
          return -1 if !include_min
        when 1
        end
      end

      if max
        case version <=> max
        when -1
        when 0
          return 1 if !include_max
        when 1
          return 1
        end
      end

      0
    end

    def strictly_lower?(other)
      return false if !max || !other.min

      case max <=> other.min
      when 0
        !include_max || !other.include_min
      when -1
        true
      when 1
        false
      end
    end

    def strictly_higher?(other)
      other.strictly_lower?(self)
    end

    def intersects?(other)
      return false if other.empty?
      return other.intersects?(self) if other.is_a?(VersionUnion)
      !strictly_lower?(other) && !strictly_higher?(other)
    end
    alias_method :allows_any?, :intersects?

    def intersect(other)
      return other if other.empty?
      return other.intersect(self) if other.is_a?(VersionUnion)

      min_range =
        if !min
          other
        elsif !other.min
          self
        else
          case min <=> other.min
          when 0
            include_