&&
        range.eql?(other.range)
    end

    class << self
      def exact(package, version)
        range = VersionRange.new(min: version, max: version, include_min: true, include_max: true)
        new(package, range: range)
      end

      def any(package)
        new(package, range: VersionRange.any)
      end

      def empty(package)
        new(package, range: VersionRange.empty)
      end
    end

    def intersect(other)
      unless package == other.package
        raise ArgumentError, "Can only intersect between VersionConstraint of the same package"
      end

      self.class.new(package, range: range.intersect(other.range))
    end

    def union(other)
      unless package == other.package
        raise ArgumentError, "Can only intersect between VersionConstraint of the same package"
      end

      self.class.new(package, range: range.union(other.range))
    end

                                                                                                                               gems/gems/bundler-2.4.19/lib/bundler/vendor/pub_grub/lib/pub_grub/assignment.rb                     0000644                 00000001004 15040313374 0023164 0                                                                                                    ustar 00                                                                                                                                                                                                                                                        end
    end

    def to_s(allow_every: false)
      if Package.root?(package)
        package.to_s
      elsif allow_every && any?
        "every version of #{package}"
      else
        "#{package} #{constraint_string}"
      end
    end

    def constraint_string
      if any?
        ">= 0"
      else
        range.to_s
      end
    end

    def empty?
      range.empty?
    end

    # Does this match every version of the package
    def any?
      range.any?
    end

    def inspect
      "#<#{self.class                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            gems/gems/bundler-2.4.19/lib/bundler/vendor/pub_grub/lib/pub_grub/rubygems.rb                       0000644                 00000002513 15040313374 0022657 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       require_relative 'failure_writer'

module Bundler::PubGrub
  class SolveFailure < StandardError
    attr_reader :incompatibility

    def initialize(incompatibility)
      @incompatibility = incompatibility
    end

    def to_s
      "Could not find compatible versions\n\n#{explanation}"
    end

    def explanation
      @explanation ||= FailureWriter.new(@incompatibility).write
    end
  end
end
                                                                                                              gems/gems/bundler-2.4.19/lib/bundler/vendor/pub_grub/lib/pub_grub/version_solver.rb                 0000644                 00000016041 15040313375 0024103 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       require_relative 'partial_solution'
require_relative 'term'
require_relative 'incompatibility'
require_relative 'solve_failure'

module Bundler::PubGrub
  class VersionSolver
    attr_reader :logger
    attr_reader :source
    attr_reader :solution

    def initialize(source:, root: Package.root, logger: Bundler::PubGrub.logger)
                                                                                                                                                                                     gems/gems/bundler-2.4.19/lib/bundler/vendor/pub_grub/lib/pub_grub/version_constraint.rb             0000644                 00000005042 15040313375 0024754 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       n found after #{solution.attempted_solutions} attempts:" }
        solution.decisions.each do |package, version|
          next if Package.root?(package)
          logger.info { "* #{package} #{version}" }
        end

        false
      else
        true
      end
    end

    def solve
      work until solved?

      solution.decisions
    end

    alias_method :result, :solve

    private

    def propagate(initial_package)
      changed = [initial_package]
      while package = changed.shift
        @incompatibilities[package].reverse_each do |incompatibility|
          result = propagate_incompatibility(incompatibility)
          if result == :conflict
            root_cause = resolve_conflict(incompatibility)
            changed.clear
            changed << propagate_incompatibility(root_cause)
          elsif result # should be a Package
            changed << result
          end
        end
        changed.uniq!
      end
    end

    def propagate_incompatibility(incompatibility)
      unsatisfied = nil
      incompatibility.terms.each do |term|
        relation = solution.relation(term)
        if relation == :disjoint
          return nil
        elsif relation == :overlap
          # If more than one term is inconclusive, we can't deduce anything
          return nil if unsatisfied
          unsatisfied = term
        end
      end

      if !unsatisfied
        return :conflict
      end

      logger.debug { "derived: #{unsatisfied.invert}" }

      solution.derive(unsatisfied.invert, incompatibility)

      unsatisfied.package
    end

    def next_package_to_try
      solution.unsatisfied.min_by do |term|
        package = term.package
        range = term.constraint.range
        matching_versions = source.versions_for(package, range)
        higher_versions = source.versions_for(package, range.upper_invert)

        [matching_versions.count <= 1 ? 0 : 1, higher_versions.count]
      end.package
    end

    def choose_package_version
      if solution.unsatisfied.empty?
        logger.info "No packages unsatisfied. Solving co