 to command execution.
    #
    # ==== Example
    #
    #   inside('vendor') do
    #     run('ln -s ~/edge rails')
    #   end
    #
    def run(command, config = {})
      return unless behavior == :invoke

      destination = relative_to_original_destination_root(destination_root, false)
      desc = "#{command} from #{destination.inspect}"

      if config[:with]
        desc = "#{File.basename(config[:with].to_s)} #{desc}"
        command = "#{config[:with]} #{command}"
      end

      say_status :run, desc, config.fetch(:verbose, true)

      return if options[:pretend]

      env_splat = [config[:env]] if config[:env]

      if config[:capture]
        require "open3"
        result, status = Open3.capture2e(*env_splat, command.to_s)
        success = status.success?
      else
        result = system(*env_splat, command.to_s)
        success = result
      end

      abort if !success && config.fetch(:abort_on_failure, self.class.exit_on_failure?)

      result
    end

    # Executes a ruby script (taking into account WIN32 platform quirks).
    #
    # ==== Parameters
    # command<String>:: the command to be executed.
    # config<Hash>:: give :verbose => false to not log the status.
    #
    def run_ruby_script(command, config = {})
      return unless behavior == :invoke
      run command, config.merge(:with => Bundler::Thor::Util.ruby_command)
    end

    # Run a thor command. A hash of options can be given and it's converted to
    # switches.
    #
    # ==== Parameters
    # command<String>:: the command to be invoked
    # args<Array>:: arguments to the command
    # config<Hash>:: give :verbose => false to not log the status, :capture => true to hide to output.
    #                Other options are given as parameter to Bundler::Thor.
    #
    #
    # ==== Examples
    #
    #   thor :install, "http://gist.github.com/103208"
    #   #=> thor install http://gist.github.com/103208
    #
    #   thor :list, :all => true, :substring => 'rails'
    #   #=> thor list --all --substring=rails
    #
    def thor(command, *args)
      config  = args.last.is_a?(Hash) ? args.pop : {}
      verbose = config.key?(:verbose) ? config.delete(:verbose) : true
      pretend = config.key?(:pretend) ? config.delete(:pretend) : false
      capture = config.key?(:capture) ? config.delete(:capture) : false

      args.unshift(command)
      args.push Bundler::Thor::Options.to_switches(config)
      command = args.join(" ").strip

      run command, :with => :thor, :verbose => verbose, :pretend => pretend, :capture => capture
    end

  protected

    # Allow current root to be shared between invocations.
    #
    def _shared_configuration #:nodoc:
      super.merge!(:destination_root => destination_root)
    end

    def _cleanup_options_and_set(options, key) #:nodoc:
      case options
      when Array
        %w(--force -f --skip -s).each { |i| options.delete(i) }
        options << "--#{key}"
      when Hash
        [:force, :skip, "force", "skip"].each { |i| options.delete(i) }
        options.merge!(key => true)
      end
    end
  end
end
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                gems/gems/bundler-2.4.19/lib/bundler/vendor/thor/lib/thor/actions/file_manipulation.rb              0000644                 00000031621 15040313401 0024470 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       require "erb"

class Bundler::Thor
  module Actions
    # Copies the file from the relative source to the relative destination. If
    # the destination is not given it's assumed to be equal to the source.
    #
    # ==== Parameters
    # source<String>:: the relative path to the source root.
    # destination<String>:: the relative path to the destination root.
    # config<Hash>:: give :verbose => false to not log the status, and
    #                :mode => :preserve, to preserve the file mode from the source.

    #
    # ==== Examples
    #
    #   copy_file "README", "doc/README"
    #
    #   copy_file "doc/README"
    #
    def copy_file(source, *args, &block)
      config = args.last.is_a?(Hash) ? args.pop : {}
      destination = args.first || source
      source = File.expand_path(find_in_source_paths(source.to_s))

      resulting_destination = create_file destination, nil, config do
        content = File.binread(source)
        content = yield(content) if block
        content
      end
      if config[:mode] == :preserve
        mode = File.stat(source).mode
        chmod(resulting_destination, mode, config)
      end
    end

    # Links the file from the relative source to the relative destination. If
    # the destination is not given it's assumed to be equal to the source.
    #
    # ==== Parameters
    # source<String>:: the relative path to the source root.
    # destination<String>:: the relative path to the destination root.
    # config<Hash>:: give :verbose => false to not log the status.
    #
    # ==== Examples
    #
    #   link_file "README", "doc/README"
    #
    #   link_file "doc/README"
    #
    def link_file(source, *args)
      config = args.last.is_a?(Hash) ? args.pop : {}
      destination = args.first || source
      source = File.expand_path(find_in_source_paths(source.to_s))

      create_link destination, source, config
    end

    # Gets the content at the given address and places it at the given relative
    # destination. If a block is given instead of destination, the content of
    # the url is yielded and used as location.
    #
    # +get+ relies on open-uri, so passing application user input would provide
    # a command injection attack vector.
    #
    # ==== Parameters
    # source<String>:: the address of the given content.
    # destination<String>:: the relative path to the destination root.
    # config<Hash>:: give :verbose => false to not log the status.
    #
    # ==== Examples
    #
    #   get "http://gist.github.com/103208", "doc/README"
    #
    #   get "http://gist.github.com/103208" do |content|
    #     content.split("\n").first
    #   end
    #
    def get(source, *args, &block)
      config = args.last.is_a?(Hash) ? args.pop : {}
      destination = args.first

      render = if source =~ %r{^https?\://}
        require "open-uri"
        URI.send(:open, source) { |input| input.binmode.read }
      else
        source = File.expand_path(find_in_source_paths(source.to_s))
        open(source) { |input| input.binmode.read }
      end

      destination ||= if block_given?
        block.arity == 1 ? yield(render) : yield
      else
        File.basename(source)
      end

      create_file destination, render, config
    end

    # Gets an ERB template at the relative source, executes it and makes a copy
    # at the relative destination. If the destination is not given it's assumed
    # to be equal to the source removing .tt from the filename.
    #
    # ==== Parameters
    # source<String>:: the relative path to the source root.
    # destination<String>:: the relative path to the destination root.
    # config<Hash>:: give :verbose => false to not log the status.
    #
    # ==== Examples
    #
    #   template "README", "doc/README"
    #
    #   template "doc/README"
    #
    def template(source, *args, &block)
      config = args.last.is_a?(Hash) ? args.pop : {}
      destination = args.first || source.sub(/#{TEMPLATE_EXTNAME}$/, "")

      source  = File.expand_path(find_in_source_paths(source.to_s))
      context = config.delete(:context) || instance_eval("binding")

      create_file destination, nil, config do
        match = ERB.version.match(/(\d+\.\d+\.\d+)/)
        capturable_erb = if match && match[1] >= "2.2.0" # Ruby 2.6+
          CapturableERB.new(::File.binread(source), :trim_mode => "-", :eoutvar => "@output_buffer")
        else
          CapturableERB.new(::File.binread(source), nil, "-", "@output_buffer")
        end
        content = capturable_erb.tap do |erb|
          erb.filename = source
        end.result(context)
        content = yield(conten                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                gems/gems/bundler-2.4.19/lib/bundler/vendor/thor/lib/thor/actions/file_manipulation.rb              0000644                 00000031621 15040313401 0024470 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       se => false to not log the status.
    #
    # ==== Example
    #
    #   prepend_to_file 'config/environments/test.rb', 'config.gem "rspec"'
    #
    #   prepend_to_file 'config/environments/test.rb' do
    #     'config.gem "rspec"'
    #   end
    #
    def prepend_to_file(path, *args, &block)
      config = args.last.is_a?(Hash) ? args.pop : {}
      config[:after] = /\A/
      insert_into_file(path, *(args << config), &block)
    end
    alias_method :prepend_file, :prepend_to_file

    # Append text to a file. Since it depends on insert_into_file, it's reversible.
    #
    # ==== Parameters
    # path<String>:: path of the file to be changed
    # data<String>:: the data to append to the file, can be also given as a block.
    # config<Hash>:: give :verbose => false to not log the status.
    #
    # ==== Example
    #
    #   append_to_file 'config/environments/test.rb', 'config.gem "rspec"'
    #
    #   append_to_file 'config/environments/test.rb' do
    #     'config.gem "rspec"'
    #   end
    #
    def append_to_file(path, *args, &block)
      config = args.last.is_a?(Hash) ? args.pop : {}
      config[:before] = /\z/
      insert_into_file(path, *(args << config), &block)
    end
    alias_method :append_file, :append_to_file

    # Injects text right after the class definition. Since it depends on
    # insert_into_file, it's reversible.
    #
    # ==== Parameters
    # path<String>:: path of the file to be changed
    # klass<String|Class>:: the class to be manipulated
    # data<String>:: the data to append to the class, can be also given as a block.
    # config<Hash>:: give :verbose => false to not log the status.
    #
    # ==== Examples
    #
    #   inject_into_class "app/controllers/application_controller.rb", "ApplicationController", "  filter_parameter :password\n"
    #
    #   inject_into_class "app/controllers/application_controller.rb", "ApplicationController" do
    #     "  filter_parameter :password\n"
    #   end
    #
    def inject_into_class(path, klass, *args, &block)
      config = args.last.is_a?(Hash) ? args.pop : {}
      config[:after] = /class #{klass}\n|class #{klass} .*\n/
      insert_into_file(path, *(args << config), &block)
    end

    # Injects text right after the module definition. Since it depends on
    # insert_into_file, it's reversible.
    #
    # ==== Parameters
    # path<String>:: path of the file to be changed
    # module_name<String|Class>:: the module to be manipulated
    # data<String>:: the data to append to the class, can be also given as a block.
    # config<Hash>:: give :verbose => false to not log the status.
    #
    # ==== Examples
    #
    #   inject_into_module "app/helpers/application_helper.rb", "ApplicationHelper", "  def help; 'help'; end\n"
    #
    #   inject_into_module "app/helpers/application_helper.rb", "ApplicationHelper" do
    #     "  def help; 'help'; end\n"
    #   end
    #
    def inject_into_module(path, module_name, *args, &block)
      config = args.last.is_a?(Hash) ? args.pop : {}
      config[:after] = /module #{module_name}\n|module #{module_name} .*\n/
      insert_into_file(path, *(args << config), &block)
    end

    # Run a regular expression replacement on a file.
    #
    # ==== Parameters
    # path<String>:: path of the file to be changed
    # flag<Regexp|String>:: the regexp or string to be replaced
    # replacement<String>:: the replacement, can be also given as a block
    # config<Hash>: