n_root)
      say_status :gsub, relative_to_original_destination_root(path), config.fetch(:verbose, true)

      unless options[:pretend]
        content = File.binread(path)
        content.gsub!(flag, *args, &block)
        File.open(path, "wb") { |file| file.write(content) }
      end
    end

    # Uncomment all lines matching a given regex.  It will leave the space
    # which existed before the comment hash in tact but will remove any spacing
    # between the comment hash and the beginning of the line.
    #
    # ==== Parameters
    # path<String>:: path of the file to be changed
    # flag<Regexp|String>:: the regexp or string used to decide which lines to uncomment
    # config<Hash>:: give :verbose => false to not log the status.
    #
    # ==== Example
    #
    #   uncomment_lines 'config/initializers/session_store.rb', /active_record/
    #
    def uncomment_lines(path, flag, *args)
      flag = flag.respond_to?(:source) ? flag.source : flag

      gsub_file(path, /^(\s*)#[[:blank:]]*(.*#{flag})/, '\1\2', *args)
    end

    # Comment all lines matching a given regex.  It will leave the space
    # which existed before the beginning of the line in tact and will insert
    # a single space after the comment hash.
    #
    # ==== Parameters
    # path<String>:: path of the file to be changed
    # flag<Regexp|String>:: the regexp or string used to decide which lines to comment
    # config<Hash>:: give :verbose => false to not log the status.
    #
    # ==== Example
    #
    #   comment_lines 'config/initializers/session_store.rb', /cookie_store/
    #
    def comment_lines(path, flag, *args)
      flag = flag.respond_to?(:source) ? flag.source : flag

      gsub_file(path, /^(\s*)([^#\n]*#{flag})/, '\1# \2', *args)
    end

    # Removes a file at the given location.
    #
    # ==== Parameters
    # path<String>:: path of the file to be changed
    # config<Hash>:: give :verbose => false to not log the status.
    #
    # ==== Example
    #
    #   remove_file 'README'
    #   remove_file 'app/controllers/application_controller.rb'
    #
    def remove_file(path, config = {})
      return unless behavior == :invoke
      path = File.expand_path(path, destination_root)

      say_status :remove, relative_to_original_destination_root(path), config.fetch(:verbose, true)
      if !options[:pretend] && (File.exist?(path) || File.symlink?(path))
        require "fileutils"
        ::FileUtils.rm_rf(path)
      end
    end
    alias_method :remove_dir, :remove_file

    attr_accessor :output_buffer
    private :output_buffer, :output_buffer=

  private

    def concat(string)
      @output_buffer.concat(string)
    end

    def capture(*args)
      with_output_buffer { yield(*args) }
    end

    def with_output_buffer(buf = "".dup) #:nodoc:
      raise ArgumentError, "Buffer can not be a frozen object" if buf.frozen?
      old_buffer = output_buffer
      self.output_buffer = buf
      yield
      output_buffer
    ensure
      self.output_buffer = old_buffer
    end

    # Bundler::Thor::Actions#capture depends on what kind of buffer is used in ERB.
    # Thus CapturableERB fixes ERB to use String buffer.
    class CapturableERB < ERB
      def set_eoutvar(compiler, eoutvar = "_erbout")
        compiler.put_cmd = "#{eoutvar}.concat"
        compiler.insert_cmd = "#{eoutvar}.concat"
        compiler.pre_cmd = ["#{eoutvar} = ''.dup"]
        compiler.post_cmd = [eoutvar]
      end
    end
  end
end
                                                                                                     