end

      # SIGNATURE: The hook invoked by start.
      def dispatch(command, given_args, given_opts, config) #:nodoc:
        raise NotImplementedError
      end
    end
  end
end
                                                                                                                                                                                                                                                                                                                                          gems/gems/bundler-2.4.19/lib/bundler/vendor/thor/lib/thor/rake_compat.rb                            0000644                 00000004166 15040313404 0021625 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       require "rake"
require "rake/dsl_definition"

class Bundler::Thor
  # Adds a compatibility layer to your Bundler::Thor classes which allows you to use
  # rake package tasks. For example, to use rspec rake tasks, one can do:
  #
  #   require 'bundler/vendor/thor/lib/thor/rake_compat'
  #   require 'rspec/core/rake_task'
  #
  #   class Default < Bundler::Thor
  #     include Bundler::Thor::RakeCompat
  #
  #     RSpec::Core::RakeTask.new(:spec) do |t|
  #       t.spec_opts = ['--options', './.rspec']
  #       t.spec_files = FileList['spec/**/*_spec.rb']
  #     end
  #   end
  #
  module RakeCompat
    include Rake::DSL if defined?(Rake::DSL)

    def self.rake_classes
      @rake_classes ||= []
    end

    def self.included(base)
      super(base)
      # Hack. Make rakefile point to invoker, so rdoc task is generated properly.
      rakefile = File.basename(caller[0].match(/(.*):\d+/)[1])
      Rake.application.instance_variable_set(:@rakefile, rakefile)
      rake_classes << base
    end
  end
end

# override task on (main), for compatibility with Rake 0.9
instance_eval do
  alias rake_namespace namespace

  def task(*)
    task = super

    if klass = Bundler::Thor::RakeCompat.rake_classes.last # rubocop:disable AssignmentInCondition
      non_namespaced_na