    # conditions are met.
      #
      def invoke_with_conflict_check(&block)
        if exists?
          on_conflict_behavior(&block)
        else
          yield unless pretend?
          say_status :create, :green
        end

        destination
      rescue Errno::EISDIR, Errno::EEXIST
        on_file_clash_behavior
      end

      def on_file_clash_behavior
        say_status :file_clash, :red
      end

      # What to do when the destination file already exists.
      #
      def on_conflict_behavior
        say_status :exist, :blue
      end

      # Shortcut to say_status shell method.
      #
      def say_status(status, color)
        base.shell.say_status status, relative_destination, color if config[:verbose]
      end
    end
  end
end
                                                                                                                                                                                                                                                                    gems/gems/bundler-2.4.19/lib/bundler/vendor/thor/lib/thor/actions/create_link.rb                    0000644                 00000003555 15040313402 0023257 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       gems/gems/bundler-2.4.19/lib/bundler/vendor/thor/lib/thor/actions/empty_directory.rb                0000644                 00000010374 15040313401 0024215 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       tc/apache.conf"
    #
    def create_link(destination, *args)
      config = args.last.is_a?(Hash) ? args.pop : {}
      source = args.first
      action CreateLink.new(self, destination, source, config)
    end
    alias_method :add_link, :create_link

    # CreateLink is a subset of CreateFile, which instead of taking a block of
    # data, just takes a source string from the user.
    #
    class CreateLink < CreateFile #:nodoc:
      attr_reader :data

      # Checks if the content of the file at the destination is identical to the rendered result.
      #
      # ==== Returns
      # Boolean:: true if it is identical, false otherwise.
      #
      def identical?
        source = File.expand_path(render, File.dirname(destination))
        exists? && File.identical?(source, destination)
      end

      def invoke!
        invoke_with_conflict_check do
          require "fileutils"
          FileUtils.mkdir_p(File.dirname(destination))
          # Create a symlink by default
          config[:symbolic] = true if config[:symbolic].nil?
          File.unlink(destination) if exists?
          if config[:symbolic]
            File.symlink(render, destination)
          else
            File.link(render, destination)
          end
        end
        given_destination
      end

      def exists?
        super || File.symlink?(destination)
      end
    end
  end
end
                                                                                                                                                 