 = (relevant_to ? thorfiles_relevant_to(relevant_to) : Bundler::Thor::Util.thor_root_glob)
    files += thorfiles
    files -= ["#{thor_root}/thor.yml"]

    files.map! do |file|
      File.directory?(file) ? File.join(file, "main.thor") : file
    end
  end

  # Load Thorfiles relevant to the given method. If you provide "foo:bar" it
  # will load all thor files in the thor.yaml that has "foo" e "foo:bar"
  # namespaces registered.
  #
  def thorfiles_relevant_to(meth)
    lookup = [meth, meth.split(":")[0...-1].join(":")]

    files = thor_yaml.select do |_, v|
      v[:namespaces] && !(v[:namespaces] & lookup).empty?
    end

    files.map { |_, v| File.join(thor_root, (v[:filename]).to_s) }
  end

  # Display information about the given klasses. If with_module is given,
  # it shows a table with information extracted from the yaml file.
  #
  def display_klasses(with_modules = false, show_internal = false, klasses = Bundler::Thor::Base.subclasses)
    klasses -= [Bundler::Thor, Bundler::Thor::Runner, Bundler::Thor::Group] unless show_internal

    raise Error, "No Bundler::Thor commands available" if klasses.empty?
    show_modules if with_modules && !thor_yaml.empty?

    list = Hash.new { |h, k| h[k] = [] }
    groups = klasses.select { |k| k.ancestors.include?(Bundler::Thor::Group) }

    # Get classes which inherit from Bundler::Thor
    (klasses - groups).each { |k| list[k.namespace.split(":").first] += k.printable_commands(false) }

    # Get classes which inherit from Bundler::Thor::Base
    groups.map! { |k| k.printable_commands(false).first }
    list["root"] = groups

    # Order namespaces with default coming first
    list = list.sort { |a, b| a[0].sub(/^default/, "") <=> b[0].sub(/^default/, "") }
    list.each { |n, commands| display_commands(n, commands) unless commands.empty? }
  end

  def display_commands(namespace, list) #:nodoc:
    list.sort! { |a, b| a[0] <=> b[0] }

    say shell.set_color(namespace, :blue, true)
    say "-" * namespace.size

    print_table(list, :truncate => true)
    say
  end
  alias_method :display_tasks, :display_commands

  def show_modules #:nodoc:
    info = []
    labels = %w(Modules Namespaces)

    info << labels
    info << ["-" * labels[0].size, "-" * labels[1].size]

    thor_yaml.each do |name, hash|
      info << [name, hash[:namespaces].join(", ")]
    end

    print_table info
    say ""
  end
end
                                                                                                                                                              gems/gems/bundler-2.4.19/lib/bundler/vendor/thor/lib/thor/line_editor.rb                            0000644                 00000000607 15040313404 0021631 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       require_relative "line_editor/basic"
require_relative "line_editor/readline"

class Bundler::Thor
  module LineEditor
    def self.readline(prompt, options = {})
      best_available.new(prompt, options).readline
    end

    def self.best_available
      [
        Bundler::Thor::LineEditor::Readline,
        Bundler::Thor::LineEditor::Basic
      ].detect(&:available?)
    end
  end
end
                                                                                                                         gems/gems/bundler-2.4.19/lib/bundler/vendor/thor/lib/thor/invocation.rb                             0000644                 00000014111 15040313404 0021500 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       class Bundler::Thor
  module Invocation
    def self.included(base) #:nodoc:
      super(base)
      base.extend ClassMethods
    end

    module ClassMethods
      # This method is responsible for receiving a name and find the proper
      # class and command for it. The key is an optional parameter which is
      # available only in class methods invocations (i.e. in Bundler::Thor::Group).
      def prepare_for_invocation(key, name) #:nodoc:
        case name
        when Symbol, String
          Bundler::Thor::Util.find_class_and_command_by_namespace(name.to_s, !key)
        else
          name
        end
      end
    end

    # Make initializer aware of invocations and the initialization args.
    def initialize(args = [], options = {}, config = {}, &block) #:nodoc:
      @_invocations = config[:invocations] || Hash.new { |h, k| h[k] = [] }
      @_initializer = [args, options, config]
      super
    end

    # Make the current command chain accessible with in a Bundler::Thor-(sub)command
    def current_command_chain
      @_invocations.values.flatten.map(&:to_sym)
    end

    # Receives a name and invokes it. The name can be a string (either "command" or
    # "namespace:command"), a Bundler::Thor::Command, a Class or a Bundler::Thor instance. If the
    # command cannot be guessed by name, it can also be supplied as second argument.
    #
    # You can also supply the arguments, options and configuration values for
    # the command to be invoked, if none is given, the same values used to
    # initialize the invoker are used to initialize the invoked.
    #
    # When no name is given, it will invoke the default command of the current class.
    #
    # ==== Examples
    #
    #   class A < Bundler::Thor
    #     def foo
    #       invoke :bar
    #       invoke "b:hello", ["Erik"]
    #     end
    #
    #     def bar
    #       invoke "b:hello", ["Erik"]
    #     end
    #   end
    #
    #   class B < Bundler::Thor
    #     def hello(name)
    #       puts "hello #{name}"
    #     end
    #   end
    #
    # You can notice that the method "foo" above invokes two c