=~ /^--(no|skip)-([-\w]+)$/
      $2
    end

    def last?
      @pile.empty?
    end

    def peek
      @pile.first
    end

    def shift
      @pile.shift
    end

    def unshift(arg)
      if arg.is_a?(Array)
        @pile = arg + @pile
      else
        @pile.unshift(arg)
      end
    end

    def current_is_value?
      peek && peek.to_s !~ /^-{1,2}\S+/
    end

    # Runs through the argument array getting strings that contains ":" and
    # mark it as a hash:
    #
    #   [ "name:string", "age:integer"                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       gems/gems/bundler-2.4.19/lib/bundler/vendor/thor/lib/thor/parser/argument.rb                        0000644                 00000003404 15040313404 0022450 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       an error.
    #
    def parse_numeric(name)
      return shift if peek.is_a?(Numeric)

      unless peek =~ NUMERIC && $& == peek
        raise MalformattedArgumentError, "Expected numeric value for '#{name}'; got #{peek.inspect}"
      end

      value = $&.index(".") ? shift.to_f : shift.to_i
      if @switches.is_a?(Hash) && switch = @switches[name]
        if switch.enum && !switch.enum.include?(value)
          raise MalformattedArgumentError, "Expected '#{name}' to be one of #{switch.enum.join(', ')}; got #{value}"
        end
      end
      value
    end

    # Parse string:
    # for --string-arg, just return the current value in the pile
    # for --no-string-arg, nil
    # Check if the peek is included in enum if enum is provided. Otherwise raises an error.
    #
    def parse_string(name)
      if no_or_skip?(name)
        nil
      else
        value = shift
        if @switches.is_a?(Hash) && switch = @switches[name]
          if switch.enum && !switch.enum.include?(value)
            raise MalformattedArgumentError, "Expected '#{name}' to be one of #{switch.enum.join(', ')}; got #{value}"
          end
        end
        value
      end
    end

    # Raises an error if @non_assigned_required array is not empty.
    #
    def check_requirement!
      return if @non_assigned_required.empty?
      names = @non_assigned_required.map do |o|
        o.respond_to?(:switch_name) ? o.switch_name : o.human_name
      end.join("', '")
      class_name = self.class.name.split("::").last.downcase
      raise RequiredArgumentMissingError, "No value provided for required #{class_name} '#{names}'"
    end
  end
end
                                                                                                                                                                                                                                                                                                                                                                                                                    gems/gems/bundler-2.4.19/lib/bundler/vendor/thor/lib/thor/parser/arguments.rb                       0000644                 00000011154 15040313404 0022634 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       class Bundler::Thor
  class Option < Argument #:nodoc:
    attr_reader :aliases, :group, :lazy_default, :hide, :repeatable

    VALID_TYPES = [:boolean, :numeric, :hash, :array, :string]

    def initialize(name, options = {})
      @check_default_type = options[:check_default_type]
      options[:required] = false unless options.key?(:required)
      @repeatable     = options.fetch(:repeatable, false)
     