class Bundler::Thor
  module LineEditor
    class Basic
      attr_reader :prompt, :options

      def self.available?
        true
      end

      def initialize(prompt, options)
        @prompt = prompt
        @options = options
      end

      def readline
        $stdout.print(prompt)
        get_input
      end

    private

      def get_input
        if echo?
          $stdin.gets
        else
          # Lazy-load io/console since it is gem-ified as of 2.3
          require "io/console"
          $stdin.noecho(&:gets)
        end
      end

      def echo?
        options.fetch(:echo, true)
      end
    end
  end
end
                                                                                                                                                                                                                                                                                                                                                                                                   gems/gems/bundler-2.4.19/lib/bundler/vendor/thor/lib/thor/error.rb                                  0000644                 00000006776 15040313402 0020500 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       class Bundler::Thor
  module LineEditor
    class Readline < Basic
      def self.available?
        begin
          require "readline"
        rescue LoadError
        end

        Object.const_defined?(:Readline)
      end

      def readline
        if echo?
          ::Readline.completion_append_character = nil
          # rb-readline does not allow Readline.completion_proc= to receive nil.
          if complete = completion_proc
            ::Readline.completion_proc = complete
          end
          ::Readline.readline(prompt, add_to_history?)
        else
          super
        end
      end

    private

      def add_to_history?
        options.fetch(:add_to_history, true)
      end

      def completion_proc
        if use_path_completion?
          proc { |text| PathCompletion.new(text).matches }
        elsif completion_options.any?
          proc do |text|
            completion_options.select { |option| option.start_with?(text) }
          end
        end
      end

      def completion_options
        options.fetch(:limited_to, [])
      end

      def use_path_completion?
        options.fetch(:path, false)
      end

      class PathCompletion
        attr_reader :text
        private :text

        def initialize(text)
          @text = text
        end

        def matches
          relative_matches
        end

      private

        def relative_matches
          absolute_matches.map { |path| path.sub(base_path, "") }
        end

        def absolute_matches
          Dir[glob_pattern].map do |path|
            if File.directory?(path)
              "#{path}/"
            else
              path
            end
          end
        end

        def glob_pattern
          "#{base_path}#{text}*"
        end

        def base_path
          "#{Dir.pwd}/"
        end
      end
    end
  end
end
                                                                                                                                                                                                         gems/gems/bundler-2.4.19/lib/bundler/vendor/thor/lib/thor/util.rb                                   0000644                 00000021530 15040313403 0020306 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       require "rbconfig"

class Bundler::Thor
  module Sandbox #:nodoc:
  end

  # This module holds several utilities:
  #
  # 1) Methods to convert thor namespaces to constants and vice-versa.
  #
  #   Bundler::Thor::Util.namespace_from_thor_class(Foo::Bar::Baz) #=> "foo:bar:baz"
  #
  # 2) Loading thor files and sandboxing:
  #
  #   Bundler::Thor::Util.load_thorfile("~/.thor/foo")
  #
  module Util
    class << self
      # Receives a namespace and search for it in the Bundler::Thor::Base subclasses.
      #
      # ==== Parameters
      # namespace<String>:: The namespace to search for.
      #
      def find_by_namespace(namespace)
        namespace = "default#{namespace}" if namespace.empty? || namespace =~ /^:/
        Bundler::Thor::Base.subclasses.detect { |klass| klass.namespace == namespace }
      end

      # Receives a constant and converts it to a Bundler::Thor namespace. Since Bundler::Thor
      # commands can be added to a sandbox, this method is also responsible for
      # removing the sandb  gems/gems/bundler-2.4.19/lib/bundler/vendor/thor/lib/thor/line_editor/basic.rb                      0000644                 00000001175 15040313402 0022711 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       constant = constant.to_s.gsub(/^Bundler::Thor::Sandbox::/, "")
        constant = snake_case(constant).squeeze(":")
        constant
      end

      # Given the contents, evaluate it inside the sandbox and returns the
      # namespaces defined in the sandbox.
      #
      # ==== Parameters
      # contents<String>
      #
      # ==== Returns
      # Array[Object]
      #
      def namespaces_in_content(contents, file = __FILE__)
        old_constants = Bundler::Thor::Base.subclasses.dup
        Bundler::Thor::Base.subclasses.clear

        load_thorfile(file, contents)

        new_constants = Bundler::Thor::Base.subclasses.d                                                                                                                                                                                                                                                                                                                                                                                                   gems/gems/bundler-2.4.19/lib/bundler/vendor/thor/lib/thor/line_editor/readline.rb                   0000644                 00000003467 15040313402 0023421 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       eceives a string and convert it to camel case. camel_case returns CamelCase.
      #
      # ==== Parameters
      # String
      #
      # ==== Returns
      # String
      #
      def camel_case(str)
        return str if str !~ /_/ && str =~ /[A-Z]+.*/
        str.split("_").map(&:capitalize).join
      end

      # Receives a namespace and tries to retrieve a Bundler::Thor or Bundler::Thor::Group class
      # from it. It first searches for a class using the all the given namespace,
      # if it's not found, removes the highest entry and searches for the class
      # again. If found, returns the highest entry as the class name.
      #
      # ==== Examples
      #
      #   class Foo::Bar < Bundler::Thor
      #     def baz
      #     end
      #   end
      #
      #   class Baz::Foo < Bundler::Thor::Group
      #   end
      #
      #   Bundler::Thor::Util.namespace_to_thor_class("foo:bar")     #=> Foo::Bar, nil # will invoke default command
      #   Bundler::Thor::Util.namespace_to_thor_class("baz:foo")     #=> Baz::Foo, nil
      #   Bundler::Thor::Util.namespace_to_thor_class("foo:bar:baz") #=> Foo::Bar, "baz"
      #
      # ==== Parameters
      # namespace<String>
      #
      def find_class_and_command_by_namespace(namespace, fallback = true)
        if namespace.include?(":") # look for a namespaced command
          pieces  = namespace.split(":")
          command = pieces.pop
          klass   = Bundler::Thor::Util.find_by_namespace(pieces.join(":"))
        end
        unless klass # look for a Bundler::Thor::Group with the right name
          klass = Bundler::Thor::Util.find_by_namespace(namespace)
          command = nil
        end
        if !klass && fallback # try a command in the default namespace
          command = namespace
          klass   = Bundler::Thor::Util.find_by_namespace("                                 