 userinfo, host, port, registry,
                   path, opaque,
                   query,
                   fragment,
                   parser = nil,
                   arg_check = false)
      raise InvalidURIError unless path
      path = path.sub(/^\//,'')
      path.sub!(/^%2F/,'/')
      super(scheme, userinfo, host, port, registry, path, opaque,
            query, fragment, parser, arg_check)
      @typecode = nil
      if tmp = @path.index(TYPECODE_PREFIX)
        typecode = @path[tmp + TYPECODE_PREFIX.size..-1]
        @path = @path[0..tmp - 1]

        if arg_check
          self.typecode = typecode
        else
          self.set_typecode(typecode)
        end
      end
    end

    # typecode accessor.
    #
    # See Bundler::URI::FTP::COMPONENT.
    attr_reader :typecode

    # Validates typecode +v+,
                                                                                                                                                                                                  gems/gems/bundler-2.4.19/lib/bundler/vendor/uri/lib/uri/ftp.rb                                      0000644                 00000016430 15040313401 0017571 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       bundler/vendor/uri/lib/uri'
    #
    #   uri = Bundler::URI.parse("ftp://john@ftp.example.com/my_file.img")
    #   #=> #<Bundler::URI::FTP ftp://john@ftp.example.com/my_file.img>
    #   uri.typecode = "i"
    #   uri
    #   #=> #<Bundler::URI::FTP ftp://john@ftp.example.com/my_file.img;type=i>
    #
    def typecode=(typecode)
      check_typecode(typecode)
      set_typecode(typecode)
      typecode
    end

    def merge(oth) # :nodoc:
      tmp = super(oth)
      if self != tmp
        tmp.set_typecode(oth.typecode)
      end

      return tmp
    end

    # Returns the path from an FTP Bundler::URI.
    #
    # RFC 1738 specifically states that the path for an FTP Bundler::URI does not
    # include the / which separates the Bundler::URI path from the Bundler::URI host. Example:
    #
    # <code>ftp://ftp.example.com/pub/ruby</code>
    #
    # The above Bundler