    return @valid unless @valid.nil?
        false
      end

      def validate!(probe = nil)
        @valid = false if uri.nil?
        if @valid.nil?
          @valid = fallback_timeout == 0 || (probe || TCPSocketProbe.new).replies?(self)
        end
        self
      end
    end

    # Class used to parse one configuration line
    #
    # Gets the configuration line and the value.
    #   This object provides a `update_mirror` method
    #   used to setup the given mirror value.
    class MirrorConfig
      attr_accessor :uri, :value

      def initialize(config_line, value)
        uri, fallback =
          config_line.match(%r{\Amirror\.(all|.+?)(\.fallback_timeout)?\/?\z}).captures
        @fallback = !fallback.nil?
        @all = false
        if uri == "all"
          @all = true
        else
          @uri = Bundler::URI(uri).absolute? ? Settings.normalize_uri(uri) : uri
        end
        @value = value
      end

      def all?
        @all
      end

      def update_mirror(mirror)
        if @fallback
          mirror.fallback_timeout = @value
        else
          mirror.uri = Settings.normalize_uri(@value)
        end
      end
    end

    # Class used for probing TCP availability for a given mirror.
    class TCPSocketProbe
      def replies?(mirror)
        MirrorSockets.new(mirror).any? do |socket, address, timeout|
          socket.connect_nonblock(address)
        rescue Errno::EINPROGRESS
          wait_for_writtable_socket(socket, address, timeout)
        rescue RuntimeError # Connection failed somehow, again
          false
        end
      end

      private

      def wait_for_writtable_socket(socket, address, timeout)
        if IO.select(nil, [socket], nil, timeout)
          probe_writtable_socket(socket, address)
        else # TCP Handshake timed out, or there is something dropping packets
          false
        end
      end

      def probe_writtable_socket(socket, address)
        socket.connect_nonblock(address)
      rescue Errno::EISCONN
        true
      rescue StandardError # Connection failed
        false
      end
    end
  end

  # Class used to build the list of sockets that correspond to
  #   a given mirror.
  #
  # One mirror may correspond to many different addresses, both
  #   because of it having many dns entries or because
  #   the network interface is both ipv4 and ipv5
  class MirrorSockets
    def initialize