ss to raw HTTP/1
connection.

If +rack.hijack+ is present in +env+, it must respond to +call+
and return an +IO+ instance which can be used to read and write
to the underlying connection using HTTP/1 semantics and
formatting.

==== Partial Hijack

Partial hijack is used for bi-directional streaming of the request and
response body. It occurs after the status and headers are written by
the server and causes the server to ignore the Body of the response.

It is intended to be used when applications need bi-directional
streaming.

If +rack.hijack?+ is present in +env+ and truthy,
an application may set the special response header +rack.hijack+
to an object that responds to +call+,
accepting a +stream+ argument.

After the response status and headers have been sent, this hijack
callback will be invoked with a +stream+ argument which follows the
same interface as outlined in "Streaming Body". Servers must
ignore the +body+ part of the response tuple when the
+rack.hijack+ response header is present. Using an empty +Array+
instance is recommended.

The special response header +rack.hijack+ must only be set
if the request +env+ has a truthy +rack.hijack?+.
== The Response

=== The Status

This is an HTTP status. It must be an Integer greater than or equal to
100.

=== The Headers

The headers must be a unfrozen Hash.
The header keys must be Strings.
Special headers starting "rack." are for communicating with the
server, and must not be sent back to the client.
The header must not contain a +Status+ key.
Header keys must conform to RFC7230 token specification, i.e. cannot
contain non-printable ASCII, DQUOTE or "(),/:;<=>?@[\]{}".
Header keys must not contain uppercase ASCII characters (A-Z).
Header values must be either a String instance,
or an Array of String instances,
such that each String instance must not contain characters below 037.

=== The content-type

There must not be a <tt>content-type</tt> header key when the +Status+ is 1xx,
204, or 304.

=== The content-length

There must not be a <tt>content-length</tt> header key when the
+Status+ is 1xx, 204, or 304.

=== The Body

The Body is typically an +Array+ of +String+ instances, an enumerable
that yields +String+ instances, a +Proc+ instance, or a File-like
object.

The Body must respond to +each+ or +call+. It may optionally respond
to +to_path+ or +to_ary+. A Body that responds to +each+ is considered
to be an Enumerable Body. A Body that responds to +call+ is considered
to be a Streaming Body.

A Body that responds to both +each+ and +call+ must be treated as an
Enumerable Body, not a Streaming Body. If it responds to +each+, you
must call +each+ and not +call+. If the Body doesn't respond to
+each+, then you can assume it responds to +call+.

The Body must either be consumed or returned. The Body is consumed by
optionally calling either +each+ or +call+.
Then, if the Body responds to +close+, it must be called to release
any resources associated with the generation of the body.
In other words, +close+ must always be called at least once; typically
after the web server has sent the response to the client, but also in
cases where the Rack application makes internal/virtual requests and
discards the response.


After calling +close+, the Body is considered closed and should not
be consumed again.
If the original Body is replaced by a new Body, the new Body must
also consume the original Body by calling +close+ if possible.

If the Body responds to +to_path+, it must return a +String+
path for the local file system whose contents are identical
to that produced by calling +each+; this may be used by the
server as an alternative, possibly more efficient way to
transport the response. The +to_path+ method does not consume
the body.

==== Enumerable Body

The Enumerable Body must respond to +each+.
It must only be called once.
It must not be called after being closed.
and must only yield String values.

The Body itself should not be an instance of String, as this will
break in Ruby 1.9.

Middleware must not call +each+ directly on the Body.
Instead, middleware can return a new Body that calls +each+ on the
original Body, yielding at least once per iteration.

If the Body responds to +to_ary+, it must return an +Array+ whose
contents are identical to that produced by calling +each+.
Middleware may call +to_ary+ directly on the Body and return a new
Body in its place. In other words, middleware can only process the
Body directly if it responds to +to_ary+. If the Body responds to both
+to_ary+ and +close+, its implementation of +to_ary+ must call
+close+.

==== Streaming Body

The Streaming Body must respond to +call+.
It must only be called once.
It must not be called after being closed.
It takes a +stream+ argument.

The +stream+ argument must implement:
<tt>read, write, <<, flush, close, close_read, close_write, closed?</tt>

The semantics of these IO methods must be a best effort match to
those of a normal Ruby IO or Socket object, using standard arguments
and raising standard exceptions. Servers are encouraged to simply
pass on real IO objects, although it is recognized that this approach
is not directly compatible with HTTP/2.

== Thanks
Some parts of this specification are adopted from {PEP 333 – Python Web Server Gateway Interface v1.0}[https://peps.python.org/pep-0333/]
I'd like to thank everyone involved in that effort.
                                                                                                                                                                                                                                                             gems/gems/rack-3.0.8/CONTRIBUTING.md                                                                0000644                 00000005452 15040313411 0012245 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # Contributing to Rack

Rack is work of [hundreds of
contributors](https://github.com/rack/rack/graphs/contributors). You're
encouraged to submit [pull requests](https://github.com/rack/rack/pulls) and
[propose features and discuss issues](https://github.com/rack/rack/issues).

## Fork the Project

Fork the [project on GitHub](https://github.com/rack/rack) and check out your
copy.

```
git clone https://github.com/(your-github-username)/rack.git
cd rack
git remote add upstream https://github.com/rack/rack.git
```

## Create a Topic Branch

Make sure your fork is up-to-date and create a topic branch for your feature or
bug fix.

```
git checkout main
git pull upstream main
git checkout -b my-feature-branch
```

## Bundle Install and Quick Test

Ensure that you can build the project and run quick tests.

```
bundle install --without extra
bundle exec rake test
```

## Running All Tests

Install all dependencies.

```
bundle install
```

Run all tests.

```
rake test
```

## Write Tests

Try to write a test that reproduces the problem you're trying to fix or
describes a feature that you want to build.

We definitely appreciate pull requests that highlight or reproduce a problem,
even without a fix.

## Write Code

Implement your feature or bug fix.

Make sure that all tests pass:

```
bundle exec rake test
```

## Write Documentation

Document any external behavior in the [README](README.md).

## Update Changelog

Add a line to [CHANGELOG](CHANGELOG.md).

## Commit Changes

Make sure git knows your name and email address:

```
git config --global user.name "Your Name"
git config --global user.email "contributor@example.com"
```

Writing good commit logs is important. A commit log should describe what changed
and why.

```
git add ...
git commit
```

## Push

```
git push origin my-feature-branch
```

## Make a Pull Request

Go to your fork of rack on GitHub and select your feature branch. Click the
'Pull Request' button and fill out the form. Pull requests are usually
reviewed within a few days.

## Rebase

If you've been working on a change for a while, rebase with upstream/main.

```
git fetch upstream
git rebase upstream/main
git push origin my-feature-branch -f
```

## Make Required Changes

Amend your previous commit and force push the changes.

```
git commit --amend
git push origin my-feature-branch -f
```

## Check on Your Pull Request

Go back to your pull request after a few minutes and see whether it passed
tests with GitHub Actions. Everything should look green, otherwise fix issues and
amend your commit as described above.

## Be Patient

It's likely that your change will not be merged and that the nitpicky
maintainers will ask you to do more, or fix seemingly benign problems. Hang in
there!

## Thank You

Please do know that we really appreciate and value your time and work. We love
you, really.
                                                                                                                                                                                                                      gems/gems/json-2.6.3/lib/json.rb                                                                    0000644                 00000046455 15040313411 0012121 0                                                                                                    ustar 00                                                                                                                                                                                                                                                        ruby = JSON.parse(source)
#   ruby.class # => Array
# Use class \Set:
#   ruby = JSON.parse(source, {array_class: Set})
#   ruby # => #<Set: {"foo", 1.0, true, false, nil}>
#
# ---
#
# Option +create_additions+ (boolean) specifies whether to use \JSON additions in parsing.
# See {\JSON Additions}[#module-JSON-label-JSON+Additions].
#
# === Generating \JSON
#
# To generate a Ruby \String containing \JSON data,
# use method <tt>JSON.generate(source, opts)</tt>, where
# - +source+ is a Ruby object.
# - +opts+ is a \Hash object containing options
#   that control both input allowed and output formatting.
#
# ==== Generating \JSON from Arrays
#
# When the source is a Ruby \Array, JSON.generate returns
# a \String containing a \JSON array:
#   ruby = [0, 's', :foo]
#   json = JSON.generate(ruby)
#   json # => '[0,"s","foo"]'
#
# The Ruby \Array array may contain nested arrays, hashes, and scalars
# to any depth:
#   ruby = [0, [1, 2], {foo: 3, bar: 4}]
#   json = JSON.generate(ruby)
#   json # => '[0,[1,2],{"foo":3,"bar":4}]'
#
# ==== Generating \JSON from Hashes
#
# When the source is a Ruby \Hash, JSON.generate returns
# a \String containing a \JSON object:
#   ruby = {foo: 0, bar: 's', baz: :bat}
#   json = JSON.generate(ruby)
#   json # => '{"foo":0,"bar":"s","baz":"bat"}'
#
# The Ruby \Hash array may contain nested arrays, hashes, and scalars
# to any depth:
#   ruby = {foo: [0, 1], bar: {baz: 2, bat: 3}, bam: :bad}
#   json = JSON.generate(ruby)
#   json # => '{"foo":[0,1],"bar":{"baz":2,"bat":3},"bam":"bad"}'
#
# ==== Generating \JSON from Other Objects
#
# When the source is neither an \Array nor a \Hash,
# the generated \JSON data depends on the class of the source.
#
# When the source is a Ruby \Integer or \Float, JSON.generate returns
# a \String containing a \JSON number:
#   JSON.generate(42) # => '42'
#   JSON.generate(0.42) # => '0.42'
#
# When the source is a Ruby \String, JSON.generate returns
# a \String containing a \JSON string (with double-quotes):
#   JSON.generate('A string') # => '"A string"'
#
# When the source is +true+, +false+ or +nil+, JSON.generate returns
# a \String containing the corresponding \JSON token:
#   JSON.generate(true) # => 'true'
#   JSON.generate(false) # => 'false'
#   JSON.generate(nil) # => 'null'
#
# When the source is none of the above, JSON.generate returns
# a \String containing a \JSON string representation of the source:
#   JSON.generate(:foo) # => '"foo"'
#   JSON.generate(Complex(0, 0)) # => '"0+0i"'
#   JSON.generate(Dir.new('.')) # => '"#<Dir>"'
#
# ==== Generating Options
#
# ====== Input Options
#
# Option +allow_nan+ (boolean) specifies whether
# +NaN+, +Infinity+, and <tt>-Infinity</tt> may be generated;
# defaults to +false+.
#
# With the default, +false+:
#   # Raises JSON::GeneratorError (920: NaN not allowed in JSON):
#   JSON.generate(JSON::NaN)
#   # Raises JSON::GeneratorError (917: Infinity not allowed in JSON):
#   JSON.generate(JSON::Infinity)
#   # Raises JSON::GeneratorError (917: -Infinity not allowed in JSON):
#   JSON.generate(JSON::MinusInfinity)
#
# Allow:
#   ruby = [Float::NaN, Float::Infinity, Float::MinusInfinity]
#   JSON.generate(ruby, allow_nan: true) # => '[NaN,Infinity,-Infinity]'
#
# ---
#
# Option +max_nesting+ (\Integer) specifies the maximum nesting depth
# in +obj+; defaults to +100+.
#
# With the default, +100+:
#   obj = [[[[[[0]]]]]]
#   JSON.generate(obj) # => '[[[[[[0]]]]]]'
#
# Too deep:
#   # Raises JSON::NestingError (nesting of 2 is too deep):
#   JSON.generate(obj, max_nesting: 2)
#
# ====== Output Options
#
# The default formatting options generate the most compact
# \JSON data, all on one line and with no whitespace.
#
# You can use these formatting options to generate
# \JSON data in a more open format, using whitespace.
# See also JSON.pretty_generate.
#
# - Option +array_nl+ (\String) specifies a string (usually a newline)
#   to be inserted after each \JSON array; defaults to the empty \String, <tt>''</tt>.
# - Option +object_nl+ (\String) specifies a string (usually a newline)
#   to be inserted after each \JSON object; defaults to the empty \String, <tt>''</tt>.
# - Option +indent+ (\String) specifies the string (usually spaces) to be
#   used for indentation; defaults to the empty \String, <tt>''</tt>;
#   defaults to the empty \String, <tt>''</tt>;
#   has no effect unless options +array_nl+ or +object_nl+ specify newlines.
# - Option +space+ (\String) specifies a string (usually a space) to be
#   inserted after the colon in each \JSON object's pair;
#   defaults to the empty \String, <tt>''</tt>.
# - Option +space_before+ (\String) specifies a string (usually a space) to be
#   inserted before the colon in each \JSON object's pair;
#   defaults to the empty \String, <tt>''</tt>.
#
# In this example, +obj+ is used first to generate the shortest
# \JSON data (no whitespace), then again with all formatting options
# specified:
#
#   obj = {foo: [:bar, :baz], bat: {bam: 0, bad: 1}}
#   json = JSON.generate(obj)
#   puts 'Compact:', json
#   opts = {
#     array_nl: "\n",
#     object_nl: "\n",
#     indent: '  ',
#     space_before: ' ',
#     space: ' '
#   }
#   puts 'Open:', JSON.generate(obj, opts)
#
# Output:
#   Compact:
#   {"foo":["bar","baz"],"bat":{"bam":0,"bad":1}}
#   Open:
#   {
#     "foo" : [
#       "bar",
#       "baz"
#   ],
#     "bat" : {
#       "bam" : 0,
#       "bad" : 1
#     }
#   }
#
# == \JSON Additions
#
# When you "round trip" a non-\String object from Ruby to \JSON and back,
# you have a new \String, instead of the object you began with:
#   ruby0 = Range.new(0, 2)
#   json = JSON.generate(ruby0)
#   json # => '0..2"'
#   ruby1 = JSON.parse(json)
#   ruby1 # => '0..2'
#   ruby1.class # => String
#
# You can use \JSON _additions_ to preserve the original object.
# The addition is an extension of a ruby class, so that:
# - \JSON.generate stores more information in the \JSON string.
# - \JSON.parse, called with option +create_additions+,
#   uses that information to create a proper Ruby object.
#
# This example shows a \Range being generated into \JSON
# and parsed back into Ruby, both without and with
# the addition for \Range:
#   ruby = Range.new(0, 2)
#   # This passage does not use the addition for Range.
#   json0 = JSON.generate(ruby)
#   ruby0 = JSON.parse(json0)
#   # This passage uses the addition for Range.
#   require 'json/add/range'
#   json1 = JSON.generate(ruby)
#   ruby1 = JSON.parse(json1, create_additions: true)
#   # Make a nice display.
#   display = <<EOT
#   Generated JSON:
#     Without addition:  #{json0} (#{json0.class})
#     With addition:     #{json1} (#{json1.class})
#   Parsed JSON:
#     Without addition:  #{ruby0.inspect} (#{ruby0.class})
#     With addition:     #{ruby1.inspect} (#{ruby1.class})
#   EOT
#   puts display
#
# This output shows the different results:
#   Generated JSON:
#     Without addition:  "0..2" (String)
#     With addition:     {"json_class":"Range","a":[0,2,false]} (String)
#   Parsed JSON:
#     Without addition:  "0..2" (String)
#     With addition:     0..2 (Range)
#
# The \JSON module includes additions for certain classes.
# You can also craft custom additions.
# See {Custom \JSON Additions}[#module-JSON-label-Custom+JSON+Additions].
#
# === Built-in Additions
#
# The \JSON module includes additions for certain classes.
# To use an addition, +require+ its source:
# - BigDecimal: <tt>require 'json/add/bigdecimal'</tt>
# - Complex: <tt>require 'json/add/complex'</tt>
# - Date: <tt>require 'json/add/date'</tt>
# - DateTime: <tt>require 'json/add/date_time'</tt>
# - Exception: <tt>require 'json/add/exception'</tt>
# - OpenStruct: <tt>require 'json/add/ostruct'</tt>
# - Range: <tt>require 'json/add/range'</tt>
# - Rational: <tt>require 'json/add/rational'</tt>
# - Regexp: <tt>require 'json/add/regexp'</tt>
# - Set: <tt>require 'json/add/set'</tt>
# - Struct: <tt>require 'json/add/struct'</tt>
# - Symbol: <tt>require 'json/add/symbol'</tt>
# - Time: <tt>require 'json/add/time'</tt>
#
# To reduce punctuation clutter, the examples below
# show the generated \JSON via +puts+, rather than the usual +inspect+,
#
# \BigDecimal:
#   require 'json/add/bigdecimal'
#   ruby0 = BigDecimal(0) # 0.0
#   json = JSON.generate(ruby0) # {"json_class":"BigDecimal","b":"27:0.0"}
#   ruby1 = JSON.parse(json, create_additions: true) # 0.0
#   ruby1.class # => BigDecimal
#
# \Complex:
#   require 'json/add/complex'
#   ruby0 = Complex(1+0i) # 1+0i
#   json = JSON.generate(ruby0) # {"json_class":"Complex","r":1,"i":0}
#   ruby1 = JSON.parse(json, create_additions: true) # 1+0i
#   ruby1.class # Complex
#
# \Date:
#   require 'json/add/date'
#   ruby0 = Date.today # 2020-05-02
#   json = JSON.generate(ruby0) # {"json_class":"Date","y":2020,"m":5,"d":2,"sg":2299161.0}
#   ruby1 = JSON.parse(json, create_additions: true) # 2020-05-02
#   ruby1.class # Date
#
# \DateTime:
#   require 'json/add/date_time'
#   ruby0 = DateTime.now # 2020-05-02T10:38:13-05:00
#   json = JSON.generate(ruby0) # {"json_class":"DateTime","y":2020,"m":5,"d":2,"H":10,"M":38,"S":13,"of":"-5/24","sg":2299161.0}
#   ruby1 = JSON.parse(json, create_additions: true) # 2020-05-02T10:38:13-05:00
#   ruby1.class # DateTime
#
# \Exception (and its subclasses including \RuntimeError):
#   require 'json/add/exception'
#   ruby0 = Exception.new('A message') # A message
#   json = JSON.generate(ruby0) # {"json_class":"Exception","m":"A message","b":null}
#   ruby1 = JSON.parse(json, create_additions: true) # A message
#   ruby1.class # Exception
#   ruby0 = RuntimeError.new('Another message') # Another message
#   json = JSON.generate(ruby0) # {"json_class":"RuntimeError","m":"Another message","b":null}
#   ruby1 = JSON.parse(json, create_additions: true) # Another message
#   ruby1.class # RuntimeError
#
# \OpenStruct:
#   require 'json/add/ostruct'
#   ruby0 = OpenStruct.new(name: 'Matz', language: 'Ruby') # #<OpenStruct name="Matz", language="Ruby">
#   json = JSON.generate(ruby0) # {"json_class":"OpenStruct","t