as, Nodes::Mapping
              begin
                hash.merge! val
              rescue TypeError
                hash[key] = val
              end
            when Nodes::Sequence
              begin
                h = {}
                val.reverse_each do |value|
                  h.merge! value
                end
                hash.merge! h
              rescue TypeError
                hash[key] = val
              end
            else
              hash[key] = val
            end
          else
            if !tagged && @symbolize_names && key.is_a?(String)
              key = key.to_sym
            elsif !@freeze
              key = deduplicate(key)
            end

            hash[key] = val
          end

        }
        hash
      end

      if RUBY_VERSION < '2.7'
        def deduplicate key
          if key.is_a?(String)
            # It is important to untaint the string, otherwise it won't
            # be deduplicated into an fstring, but simply frozen.
            -(key.untaint)
          else
            key
          end
        end
      else
        def deduplicate key
          if key.is_a?(String)
            -key
          else
            key
          end
        end
      end

      def merge_key hash, key, val
      end

      def revive klass, node
        s = register(node, klass.allocate)
        init_with(s, revive_hash({}, node, true), node)
      end

      def init_with o, h, node
        c = Psych::Coder.new(node.tag)
        c.map = h

        if o.respond_to?(:init_with)
          o.init_with c
        else
          h.each { |k,v| o.instance_variable_set(:"@#{k}", v) }
        end
        o
      end

      # Convert +klassname+ to a Class
      def resolve_class klassname
        class_loader.load klassname
      end
    end

    class NoAliasRuby < ToRuby
      def visit_Psych_Nodes_Alias o
        raise AliasesNotEnabled
      end
    end
  end
end
                                                                                                                   gems/gems/psych-5.0.1/lib/psych/stream.rb                                                           0000644                 00000001633 15040313273 0013734 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true
module Psych
  ###
  # Psych::Stream is a streaming YAML emitter.  It will not buffer your YAML,
  # but send it straight to an IO.
  #
  # Here is an example use:
  #
  #   stream = Psych::Stream.new($stdout)
  #   stream.start
  #   stream.push({:foo => 'bar'})
  #   stream.finish
  #
  # YAML will be immediately emitted to $stdout with no buffering.
  #
  # Psych::Stream#start will take a block and ensure that Psych::Stream#finish
  # is called, so you can do this form:
  #
  #   stream = Psych::Stream.new($stdout)
  #   stream.start do |em|
  #     em.push(:foo => 'bar')
  #   end
  #
  class Stream < Psych::Visitors::YAMLTree
    class Emitter < Psych::Emitter # :nodoc:
      def end_document implicit_end = !streaming?
        super
      end

      def streaming?
        true
      end
    end

    include Psych::Streaming
    extend Psych::Streaming::ClassMethods
  end
end
                                                                                                     gems/gems/psych-5.0.1/lib/psych/handler.rb                                                          0000644                 00000016311 15040313274 0014056 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true
module Psych
  ###
  # Psych::Handler is an abstract base class that defines the events used
  # when dealing with Psych::Parser.  Clients who want to use Psych::Parser
  # should implement a class that inherits from Psych::Handler and define
  # events that they can handle.
  #
  # Psych::Handler defines all events that Psych::Parser can possibly send to
  # event handlers.
  #
  # See Psych::Parser for more details
  class Handler
    ###
    # Configuration options for dumping YAML.
    class DumperOptions
      attr_accessor :line_width, :indentation, :canonical

      def initialize
        @line_width  = 0
        @indentation = 2
        @canonical   = false
      end
    end

    # Default dumping options
    OPTIONS = DumperOptions.new

    # Events that a Handler should respond to.
    EVENTS = [ :alias,
               :empty,
               :end_document,
               :end_mapping,
               :end_sequence,
               :end_stream,
               :scalar,
               :start_document,
               :start_mapping,
               :start_sequence,
               :start_stream ]

    ###
    # Called with +encoding+ when the YAML stream starts.  This method is
    # called once per stream.  A stream may contain multiple documents.
    #
    # See the constants in Psych::Parser for the possible values of +encoding+.
    def start_stream encoding
    end

    ###
    # Called when the document starts with the declared +version+,
    # +tag_directives+, if the document is +implicit+.
    #
    # +version+ will be an array of integers indicating the YAML version being
    # dealt with, +tag_directives+ is a list of tuples indicating the prefix
    # and suffix of each tag, and +implicit+ is a boolean indicating whether
    # the document is started implicitly.
    #
    # === Example
    #
    # Given the following YAML:
    #
    #   %YAML 1.1
    #   %TAG ! tag:tenderlovemaking.com,2009:
    #   --- !squee
    #
    # The parameters for start_document must be this:
    #
    #   version         # => [1, 1]
    #   tag_directives  # => [["!", "tag:tenderlovemaking.com,2009:"]]
    #   implicit        # => false
    def start_document version, tag_directives, implicit
    end

    ###
    # Called with the document ends.  +implicit+ is a boolean value indicating
    # whether or not the document has an implicit ending.
    #
    # === Example
    #
    # Given the following YAML:
    #
    #   ---
    #     hello world
    #
    # +implicit+ will be true.  Given this YAML:
    #
    #   ---
    #     hello world
    #   ...
    #
    # +implicit+ will be false.
    def end_document implicit
    end

    ###
    # Called when an alias is found to +anchor+.  +anchor+ will be the name
    # of the anchor found.
    #
    # === Example
    #
    # Here we have an example of an array that references itself in YAML:
    #
    #   --- &ponies
    #   - first element
    #   - *ponies
    #
    # &ponies is the anchor, *ponies is the alias.  In this case, alias is
    # called with "ponies".
    def alias anchor
    end

    ###
    # Called when a scalar +value+ is found.  The scalar may have an
    # +anchor+, a +tag+, be implicitly +plain+ or implicitly +quoted+
    #
    #