# frozen_string_literal: true
require_relative '../tree_builder'

module Psych
  module Handlers
    class DocumentStream < Psych::TreeBuilder # :nodoc:
      def initialize &block
        super
        @block = block
      end

      def start_document version, tag_directives, implicit
        n = Nodes::Document.new version, tag_directives, implicit
        push n
      end

      def end_document implicit_end = !streaming?
        @last.implicit_end = implicit_end
        @block.call pop
      end
    end
  end
end
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    gems/gems/psych-5.0.1/lib/psych/handlers/recorder.rb                                                0000644                 00000001573 15040313276 0016054 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true
require_relative '../handler'

module Psych
  module Handlers
    ###
    # This handler will capture an event and record the event.  Recorder events
    # are available vial Psych::Handlers::Recorder#events.
    #
    # For example:
    #
    #   recorder = Psych::Handlers::Recorder.new
    #   parser = Psych::Parser.new recorder
    #   parser.parse '--- foo'
    #
    #   recorder.events # => [list of events]
    #
    #   # Replay the events
    #
    #   emitter = Psych::Emitter.new $stdout
    #   recorder.events.each do |m, args|
    #     emitter.send m, *args
    #   end

    class Recorder < Psych::Handler
      attr_reader :events

      def initialize
        @events = []
        super
      end

      EVENTS.each do |event|
        define_method event do |*args|
          @events << [event, args]
        end
      end
    end
  end
end
     