# frozen_string_literal: true
require_relative 'ruby_events'
require_relative 'yaml_events'

module Psych
  module JSON
    class Stream < Psych::Visitors::JSONTree
      include Psych::JSON::RubyEvents
      include Psych::Streaming
      extend Psych::Streaming::ClassMethods

      class Emitter < Psych::Stream::Emitter # :nodoc:
        include Psych::JSON:                                                                                                                                                      gems/gems/psych-5.0.1/lib/psych/streaming.rb                                                        0000644                 00000001233 15040313302 0014417 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true
module Psych
  module JSON
    module RubyEvents # :nodoc:
      def visit_Time o
        formatted = format_time o
        @emitter.scalar formatted, nil, nil, false, true, Nodes::Scalar::DOUBLE_QUOTED
      end

      def visit_DateTime o
        visit_Time o.to_time
      end

      def visit_String o
        @emitter.scalar o.to_s, nil, nil, false, true, Nodes::Scalar::DOUBLE_QUOTED
      end
      alias :visit_Symbol :visit_String
    end
  end
end
                        gems/gems/psych-5.0.1/lib/psych/json/tree_builder.rb                                                0000644                 00000000543 15040313305 0016052                                                                                                                                                                                                                                                                                                                                                                     gems/gems/psych-5.0.1/lib/psych/syntax_error.rb                                                     0000644                 00000001114 15040313302 0015163 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       gems/gems/psych-5.0.1/lib/psych/visitors.rb                                                         0000644                 00000000376 15040313306 0014323 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true
require_relative 'visitors/visitor'
require_re                                                                                                                                                                                                                                                                                                                                                                                                                                                    gems/gems/psych-5.0.1/lib/psych/json/yaml_events.rb                                                 0000644                 00000001413 15040313303 0015726 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module Psych
  ###
  # Scan scalars for built in types
  class ScalarScanner
    # Taken from http://yaml.org/type/timestamp.html
    TIME = /^-?\d{4}-\d{1,2}-\d{1,2}(?:[Tt]|\s+)\d{1,2}:\d\d:\d\d(?:\.\d*)?(?:\s*(?:Z|[-+]\d{1,2}:?(?:\d\d)?))?$/

    # Taken from http://yaml.org/type/float.html
    # Base 60, [-+]inf and NaN are handled separately
    FLOAT = /^(?:[-+]?([0-9][0-9_,]*)?\.[0-9]*([eE][-+][0-9]+)?(?# base 10))$/x

    # Taken from http://yaml.org/type/int.html
    INTEGER_STRICT = /^(?:[-+]?0b[0-1_]+                  (?# base 2)
                         |[-+]?0[0-7_]+                   (?# base 8)
                         |[-+]?(0|[1-9][0-9_]*)         