ept v
          end
          @emitter.end_mapping
        end
      end

      def dump_list o
      end

      def dump_exception o, msg
        tag = ['!ruby/exception', o.class.name].join ':'

        @emitter.start_mapping nil, tag, false, Nodes::Mapping::BLOCK

        if msg
          @emitter.scalar 'message', nil, nil, true, false, Nodes::Scalar::ANY
          accept msg
        end

        @emitter.scalar 'backtrace', nil, nil, true, false, Nodes::Scalar::ANY
        accept o.backtrace

        dump_ivars o

        @emitter.end_mapping
      end

      def format_time time, utc = time.utc?
        if utc
          time.strftime("%Y-%m-%d %H:%M:%S.%9N Z")
        else
          time.strftime("%Y-%m-%d %H:%M:%S.%9N %:z")
        end
      end

      def register target, yaml_obj
        @st.register target, yaml_obj
        yaml_obj
      end

      def dump_coder o
        @coders << o
        tag = Psych.dump_tags[o.class]
        unless tag
          klass = o.class == Object ? nil : o.class.name
          tag   = ['!ruby/object', klass].compact.join(':')
        end

        c = Psych::Coder.new(tag)
        o.encode_with(c)
        emit_coder c, o
      end

      def emit_coder c, o
        case c.type
        when :scalar
          @emitter.scalar c.scalar, nil, c.tag, c.tag.nil?, false, c.style
        when :seq
          @emitter.start_sequence nil, c.tag, c.tag.nil?, c.style
          c.seq.each do |thing|
            accept thing
          end
          @emitter.end_sequence
        when :map
          register o, @emitter.start_mapping(nil, c.tag, c.implicit, c.style)
          c.map.each do |k,v|
            accept k
            accept v
          end
          @emitter.end_mapping
        when :object
          accept c.object
        end
      end

      def dump_ivars target
        target.instance_variables.each do |iv|
          @emitter.scalar("#{iv.to_s.sub(/^@/, '')}", nil, nil, true, false, Nodes::Scalar::ANY)
          accept target.instance_variable_get(iv)
        end
      end
    end

    class RestrictedYAMLTree < YAMLTree
      DEFAULT_PERMITTED_CLASSES = {
        TrueClass => true,
        FalseClass => true,
        NilClass => true,
        Integer => true,
        Float => true,
        String => true,
        Array => true,
        Hash => true,
      }.compare_by_identity.freeze

      def initialize emitter, ss, options
        super
        @permitted_classes = DEFAULT_PERMITTED_CLASSES.dup
        Array(options[:permitted_classes]).each do |klass|
          @permitted_classes[klass] = true
        end
        @permitted_symbols = {}.compare_by_identity
        Array(options[:permitted_symbols]).each do |symbol|
          @permitted_symbols[symbol] = true
        end
        @aliases = options.fetch(:aliases, false)
      end

      def accept target
        if !@aliases && @st.key?(target)
          raise BadAlias, "Tried to dump an aliased object"
        end

        unless @permitted_classes[target.class]
          raise DisallowedClass.new('dump', target.class.name || target.class.inspect)
        end

        super
      end

      def visit_Symbol sym
        unless @permitted_symbols[sym]
          raise DisallowedClass.new('dump', "Symbol(#{sym.inspect})")
        end

        super
      end
    end
  end
end
                                                                                                                                                                                                                                                                 gems/gems/psych-5.0.1/lib/psych/visitors/to_ruby.rb                                                 0000644                 00000030615 15040313273 0016010 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true
require_relative '../scalar_scanner'
require_relative '../class_loader'
require_relative '../exception'

unless defined?(Regexp::NOENCODING)
  Regexp::NOENCODING = 32
end

module Psych
  module Visitors
    ###
    # This class walks a YAML AST, converting each node to Ruby
    class ToRuby < Psych::Visitors::Visitor
      def self.create(symbolize_names: false, freeze: false, strict_integer: false)
        class_loader = ClassLoader.new
        scanner      = ScalarScanner.new class_loader, strict_integer: strict_integer
        new(scanner, class_loader, symbolize_names: symbolize_names, freeze: freeze)
      end

      attr_reader :class_loader

      def initialize ss, class_loader, symbolize_names: false, freeze: false
        super()
        @st = {}
        @ss = ss
        @load_tags = Psych.load_tags
        @domain_types = Psych.domain_types
        @class_loader = class_loader
        @symbolize_names = symbolize_names
        @freeze = freeze
      end

      def accept target
        result = super

        unless @domain_types.empty? || !target.tag
          key = target.tag.sub(/^[!\/]*/, '').sub(/(,\d+)\//, '\1:')
          key = "tag:#{key}" unless key =~ /^(?:tag:|x-private)/

          if @domain_types.key? key
            value, block = @domain_types[key]
            result = block.call value, result
          end
        end

        result = deduplicate(result).freeze if @freeze
        result
      end

      def deserialize o
        if klass = resolve_class(@load_tags[o.tag])
          instance = klass.allocate

          if instance.respond_to?(:init_with)
            coder = Psych::Coder.new(o.tag)
            coder.scalar = o.value
            instance.init_with coder
          end

          return instance
        end

        return o.value if o.quoted
        return @ss.tokenize(o.value) unless o.tag

        case o.tag
        when '!binary', 'tag:yaml.org,2002:binary'
          o.value.unpack('m').first
        when /^!(?:str|ruby\/string)(?::(.*))?$/, 'tag:yaml.org,2002:str'
          klass = resolve_class($1)
          if klass
            klass.allocate.replace o.value
          else
            o.value
          end
        when '!ruby/object:BigDecimal'
          require 'bigdecimal' unless defined? BigDecimal
          class_loader.big_decimal._load o.value
        when "!ruby/object:DateTime"
          class_loader.date_time
          require 'date' unless defined? DateTime
          t = @ss.parse_time(o.value)
          DateTime.civil(*t.to_a[0, 6].reverse, Rational(t.utc_offset, 86400)) +
            (t.subsec/86400)
        when '!ruby/encoding'
          ::Encoding.find o.value
        when "!ruby/object:Complex"
          class_loader.complex
          Complex(o.value)
        when "!ruby/object:Rational"
          class_loader.rational
          Rational(o.value)
        when "!ruby/class", "!ruby/module"
          resolve_class o.value
        when "tag:yaml.org,2002:float", "!float"
          Float(@ss.tokenize(o.value))
        when "!ruby/regexp"
          klass = class_loader.regexp
          o.value =~ /^\/(.*)\/([mixn]*)$/m
          source  = $1
          options = 0
          lang    = nil
          ($2 || '').split('').each do |option|
            case option
            when 'x' then options |= Regexp::EXTENDED
            when 'i' then options |= Regexp::IGNORECASE
            when 'm' then options |= Regexp::MULTILINE
            when 'n' then options |= Regexp::NOENCODING
            else lang = option
            end
          end
          klass.new(*[source, options, lang].compact)
        when "!ruby/range"
          klass = class_loader.range
          args = o.value.split(/([.]{2,3})/, 2).map { |s|
            accept Nodes::Scalar.new(s)
          }
          args.push(args.delete_at(1) == '...')
          klass.new(*args)
        when /^!ruby\/sym(bol)?:?(.*)?$/
          class_loader.symbolize o.value
        else
          @ss.tokenize o.value
        end
      end
      private :deserialize

      def visit_Psych_Nodes_Scalar o
        register o, deserialize(o)
      end

      def visit_Psych_Nodes_Sequence o
        if klass = resolve_class(@load_tags[o.tag])
          instance = klass.allocate

          if instance.respond_to?(:init_with)
            coder = Psych::Coder.new(o.tag)
            coder.seq = o.children.map { |c| accept c }
            instance.init_with coder
          end

          return instance
        end

        case o.tag
        when nil
          register_empty(o)
        when '!omap', 'tag:yaml.org,2002:omap'
          map = register(o, Psych::Omap.new)
          o.children.each { |a|
            map[accept(a.children.first)] = accept a.children.last
          }
          map
        when /^!(?:seq|ruby\/array):(.*)$/
          klass = resolve                                                                                                                                                                                                                                                                 gems/gems/psych-5.0.1/lib/psych/visitors/to_ruby.rb                                                 0000644                 00000030615 15040313273 0016010 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                   if struct_members.include?(class_loader.symbolize(member))
                s.send("#{member}=", value)
              else
                members[member.to_s.sub(/^@/, '')] = value
              end
            end
            init_with(s, members, o)
          else
            klass = class_loader.struct
            members = o.children.map { |c| accept c }
            h = Hash[*members]
            s = klass.new(*h.map { |k,v|
              class_loader.symbolize k
            }).new(*h.map { |k,v| v })
            register(o, s)
            s
          end

        when /^!ruby\/object:?(.*)?$/
          name = $1 || 'Object'

          if name == 'Complex'
            class_loader.complex
            h = Hash[*o.children.map { |c| accept c }]
            register o, Complex(h['real'], h['image'])
          elsif name == 'Rational'
            class_loader.rational
            h = Hash[*o.children.map { |c| accept c }]
            register o, Rational(h['numerator'], h['denominator'])
          elsif name == 'Hash'
            revive_hash(register(o, {}), o)
          else
            obj = revive((resolve_class(name) || class_loader.object), o)
            obj
          end

        when /^!(?:str|ruby\/string)(?::(.*))?$/, 'tag:yaml.org,2002:str'
          klass   = resolve_class($1)
          members = {}
          string  = nil

          o.children.each_slice(2) do |k,v|
            key   = accept k
            value = accept v

            if key == 'str'
              if klass
                string = klass.allocate.replace value
              else
                string = value
              end
              register(o, string)
            else
              members[key] = value
            end
          end
          init_with(string, members.map { |k,v| [k.to_s.sub(/^@/, ''),v] }, o)
        when /^!ruby\/array:(.*)$/
          klass = resolve_class($1)
          list  = register(o, klass.allocate)

          members = Hash[o.children.map { |c| accept c }.each_slice(2).to_a]
          list.replace members['internal']

          members['ivars'].each do |ivar, v|
            list.instance_variable_set ivar, v
          end
          list

        when '!ruby/range'
          klass = class_loader.range
          h = Hash[*o.children.map { |c| accept c }]
          register o, klass.new(h['begin'], h['end'], h['excl'])

        when /^!ruby\/exception:?(.*)?$/
          h = Hash[*o.children.map { |c| accept c }]

          e = build_exception((resolve_class($1) || class_loader.exception),
                              h.delete('message'))

          e.set_backtrace h.delete('backtrace') if h.key? 'backtrace'
          init_with(e, h, o)

        when '!set', 'tag:yaml.org,2002:set'
          set = class_loader.psych_set.new
          @st[o.anchor] = set if o.anchor
          o.children.each_slice(2) do |k,v|
            set[accept(k)] = accept(v)
          end
          set

      