* There must be a valid input stream in <tt>rack.input</tt>.
* There must be a valid error stream in <tt>rack.errors</tt>.
* There may be a valid hijack callback in <tt>rack.hijack</tt>
* The <tt>REQUEST_METHOD</tt> must be a valid token.
* The <tt>SCRIPT_NAME</tt>, if non-empty, must start with <tt>/</tt>
* The <tt>PATH_INFO</tt>, if non-empty, must start with <tt>/</tt>
* The <tt>CONTENT_LENGTH</tt>, if given, must consist of digits only.
* One of <tt>SCRIPT_NAME</tt> or <tt>PATH_INFO</tt> must be
  set. <tt>PATH_INFO</tt> should be <tt>/</tt> if
  <tt>SCRIPT_NAME</tt> is empty.
  <tt>SCRIPT_NAME</tt> never should be <tt>/</tt>, but instead be empty.
<tt>rack.response_finished</tt>:: An array of callables run by the server after the response has been
processed. This would typically be invoked after sending the response to the client, but it could also be
invoked if an error occurs while generating the response or sending the response; in that case, the error
argument will be a subclass of +Exception+.
The callables are invoked with +env, status, headers, error+ arguments and should not raise any
exceptions. They should be invoked in reverse order of registration.

=== The Input Stream

The input stream is an IO-like object which contains the raw HTTP
POST data.
When applicable, its external encoding must be "ASCII-8BIT" and it
must be opened in binary mode, for Ruby 1.9 compatibility.
The input stream must respond to +gets+, +each+, and +read+.
* +gets+ must be called without arguments and return a string,
  or +nil+ on EOF.
* +read+ behaves like IO#read.
  Its signature is <tt>read([length, [buffer]])</tt>.

  If given, +length+ must be a non-negative Integer (>= 0) or +nil+,
  and +buffer+ must be a String and may not be nil.

  If +length+ is given and not nil, then this method reads at most
  +length+ bytes from the input stream.

  If +length+ is not given or nil, then this method reads
  all data until EOF.

  When EOF is reached, this method returns nil if +length+ is given
  and not nil, or "" if +length+ is not given or is nil.

  If +buffer+ is given, then the read data will be placed
  into +buffer+ instead of a newly created String object.
* +each+ must be called without arguments and only yield Strings.
* +close+ can be called on the input stream to indicate that the
any remaining input is not needed.

=== The Error Stream

The error stream must respond to +puts+, +write+ and +flush+.
* +puts+ must be called with a single argument that responds to +to_s+.
* +write+ must be called with a single argument that is a String.
* +flush+ must be called without arguments and must be called
  in order to make the error appear for sure.
* +close+ must never be called on the error stream.

=== Hijacking

The hijacking interfaces provides a means for an application to take
control of the HTTP connection. 