uding a response header with the time taken to process
  the request.
* `Rack::Sendfile` for working with web servers that can use optimized file
  serving for file system paths.
* `Rack::ShowException` for catching unhandled exceptions and presenting them in
  a nice and helpful way with clickable backtrace.
* `Rack::ShowStatus` for using nice error pages for empty client error
  responses.
* `Rack::Static` for more configurable serving of static files.
* `Rack::TempfileReaper` for removing temporary files creating during a request.

All these components use the same interface, which is described in detail in the
[Rack Specification]. These optional components can be used in any way you wish.

### Convenience interfaces

If you want to develop outside of existing frameworks, implement your own ones,
or develop middleware, Rack provides many helpers to create Rack applications
quickly and without doing the same web stuff all over:

* `Rack::Request` which also provides query string parsing and multipart
  handling.
* `Rack::Response` for convenient generation of HTTP replies and cookie
  handling.
* `Rack::MockRequest` and `Rack::MockResponse` for efficient and quick testing
  of Rack application without real HTTP round-trips.
* `Rack::Cascade` for trying additional Rack applications if an application
  returns a not found or method not supported response.
* `Rack::Directory` for serving files under a given directory, with directory
  indexes.
* `Rack::MediaType` for parsing content-type headers.
* `Rack::Mime` for determining content-type based on file extension.
* `Rack::RewindableInput` for making any IO object rewindable, using a temporary
  file buffer.
* `Rack::URLMap` to route to multiple applications inside the same process.

## Configuration

Rack exposes several configuration parameters to control various features of the
implementation.

### `param_depth_limit`

```ruby
Rack::Utils.param_depth_limit = 32 # default
```

The maximum amount of nesting allowed in parameters. For example, if set to 3,
this query string would be allowed:

```
?a[b][c]=d
```

but this query string would not be allowed:

```
?a[b][c][d]=e
```

Limiting the depth prevents a possible stack overflow when parsing parameters.

### `multipart_file_limit`

```ruby
Rack::Utils.multipart_file_limit = 128 # default
```

The maximum number of parts with a filename a request can contain. Accepting
too many parts can lead to the server running out of file handles.

The default is 128, which means 