received in the request body.
      #
      # This method support both application/x-www-form-urlencoded and
      # multipart/form-data.
      def POST
        if error = get_header(RACK_REQUEST_FORM_ERROR)
          raise error.class, error.message, cause: error.cause
        end

        begin
          rack_input = get_header(RACK_INPUT)

          # If the form hash was already memoized:
          if form_hash = get_header(RACK_REQUEST_FORM_HASH)
            # And it was memoized from the same input:
            if get_header(RACK_REQUEST_FORM_INPUT).equal?(rack_input)
              return form_hash
            end
          end

          # Otherwise, figure out how to parse the input:
          if rack_input.nil?
            set_header RACK_REQUEST_FORM_INPUT, nil
            set_header(RACK_REQUEST_FORM_HASH, {})
          elsif form_data? || parseable_data?
            unless set_header(RACK_REQUEST_FORM_HASH, parse_multipart)
              form_vars = get_header(RACK_INPUT).read

              # Fix for Safari Ajax postings that always append \0
              # form_vars.sub!(/\0\z/, '') # performance replacement:
              form_vars.slice!(-1) if form_vars.end_with?("\0")

              set_header RACK_REQUEST_FORM_VARS, form_vars
              set_header RACK_REQUEST_FORM_HASH, parse_query(form_vars, '&')
            end

            set_header RACK_REQUEST_FORM_INPUT, get_header(RACK_INPUT)
            get_header RACK_REQUEST_FORM_HASH
          else
            set_header RACK_REQUEST_FORM_INPUT, get_header(RACK_INPUT)
            set_header(RACK_REQUEST_FORM_HASH, {})
          end
        rescue => error
          set_header(RACK_REQUEST_FORM_ERROR, error)
          raise
        end
      end

      # The union of GET and POST data.
      #
      # Note that modifications will not be persisted in the env. Use update_param or delete_param if you want to destructively modify params.
      def params
        self.GET.merge(self.POST)
      end

      # Destructively update a parameter, whether it's in GET and/or POST. Returns nil.
      #
      # The parameter is updated wherever it was previous defined, so GET, POST, or both. If it wasn't previously defined, it's inserted into GET.
      #
      # <tt>env['rack.input']</tt> is not touched.
      def update_param(k, v)
        found = false
        if self.GET.has_key?(k)
          found = true
          self.GET[k] = v
        end
        if self.POST.has_key?(k)
          found = true
          self.POST[k] = v
        end
        unless found
          self.GET[k] = v
        end
      end

      # Destructively delete a parameter, whether it's in GET or POST. Returns the value of the deleted parameter.
      #
      # If the parameter is in both GET and POST, the POST value takes precedence since that's how #params works.
      #
      # <tt>env['rack.input']</tt> is not touched.
      def delete_param(k)
        post_value, get_value = self.POST.delete(k), self.GET.delete(k)
        post_value || get_value
      end

      def base_url
        "#{scheme}://#{host_with_port}"
      end

      # Tries to return a remake of the original request URL as a string.
      def url
        base_url + fullpath
      end

      def path
        script_name + path_info
      end

      def fullpath
        query_string.empty? ? path : "#{path}?#{query_string}"
      end

      def accept_encoding
        parse_http_accept_header(get_header("HTTP_ACCEPT_ENCODING"))
      end

      def accept_language
        parse_http_accept_header(get_header("HTTP_ACCEPT_LANGUAGE"))
      end

      def trusted_proxy?(ip)
        Rack::Request.ip_filter.call(ip)
      end

      # shortcut for <tt>request.params[key]</tt>
      def [](key)
        warn("Request#[] is deprecated and will be removed in a future version of Rack. Please use request.params[] instead", uplevel: 1)

        params[key.to_s]
      end

      # shortcut for <tt>request.params[key] = value</tt>
      #
      # Note that modifications will not be persisted in the env. Use update_param or delete_param if you want to destructively modify params.
      def []=(key, value)
        warn("Request#[]= is deprecated and will be removed in a future version of Rack. Please use request.params[]= instead", uplevel: 1)

        params[key.to_s] = value
      end

      # like Hash#values_at
      def values_at(*keys)
        keys.map { |key| params[key] }
      end

      private

      def default_session; {}; end

      # Assist with compatibility when processing `X-Forwarded-For`.
      def wrap_ipv6(host)
        # Even thought IPv6 addresses should be wrapped in square brackets,
        # sometimes this is not done in various legacy/underspecified headers.
        # So we try to fix this situation for compatibility reasons.

        # Try to detect IPv6 addresses which aren't escaped yet:
        if !host.start_with?('[') && host.count(':') > 1
          "[#{host}]"
        else
          host
        end
      end

      def parse_http_accept_header(header)
        header.to_s.split(",").each(&:strip!).map do |part|
          attribute, parameters = part.split(";", 2).each(&:strip!)
          quality = 1.0
          if parameters and /\Aq=([\d.]+)/ =~ parameters
            quality = $1.to_f
          end
          [attribute, quality]
        end
      end

      # Get an array of values set in the RFC 7239 `Forwarded` request header.
      def get_http_forwarded(token)
        Utils.forwarded_values(get_header(HTTP_FORWARDED))&.[](token)
      end

      def query_parser
        Utils.default_query_parser
      end

   