Required'
    }

    # Responses with HTTP status codes that should not have an entity body
    STATUS_WITH_NO_ENTITY_BODY = Hash[((100..199).to_a << 204 << 304).product([true])]

    SYMBOL_TO_STATUS_CODE = Hash[*HTTP_STATUS_CODES.map { |code, message|
      [message.downcase.gsub(/\s|-|'/, '_').to_sym, code]
    }.flatten]

    def status_code(status)
      if status.is_a?(Symbol)
        SYMBOL_TO_STATUS_CODE.fetch(status) { raise ArgumentError, "Unrecognized status code #{status.inspect}" }
      else
        status.to_i
      end
    end

    PATH_SEPS = Regexp.union(*[::File::SEPARATOR, ::File::ALT_SEPARATOR].compact)

    def clean_path_info(path_info)
      parts = path_info.split PATH_SEPS

      clean = []

      parts.each do |part|
        next if part.empty? || part == '.'
        part == '..' ? clean.pop : clean << part
      end

      clean_path = clean.join(::File::SEPARATOR)
      clean_path.prepend("/") if parts.empty? || parts.first.empty?
      clean_path
    end

    NULL_BYTE = "\0"

    def valid_path?(path)
      path.valid_encoding? && !path.include?(NULL_BYTE)
    end

  end
end
                                                                                                                                                                                                                                                                                                                                                                                                                             gems/gems/rack-3.0.8/lib/rack/head.rb                                                               0000644                 00000001014 15040313406 0012722 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

require_relative 'constants'
require_relative 'body_proxy'

module Rack
  # Rack::Head returns an empty body for all HEAD requests. It leaves
  # all other requests unchanged.
  class Head
    def initialize(app)
      @app = app
    end

    def call(env)
      _, _, body = response = @app.call(env)

      if env[REQUEST_METHOD] == HEAD
        response[2] = Rack::BodyProxy.new([]) do
          body.close if body.respond_to? :close
        end
      end

      response
    end
  end
end
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    gems/gems/rack-3.0.8/lib/rack/mock_request.rb                                                       0000644                 00000012573 15040313406 0014536 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

require 'uri'
require 'stringio'

require_relative 'constants'
require_relative 'mock_response'

module Rack
  # Rack::MockRequest helps testing your Rack application without
  # actually using HTTP.
  #
  # After performing a request on a URL with get/post/put/patch/delete, it
  # returns a MockResponse with useful helper methods for effective
  # testing.
  #
  # You can pass a hash with additional configuration to the
  # get/post/put/patch/delete.
  # <tt>:input</tt>:: A String or IO-like to be used as rack.input.
  # <tt>:fatal</tt>:: Raise a FatalWarning if the app writes to rack.errors.
  # <tt>:lint</tt>:: If true, wrap the application in a Rack::Lint.

  class MockRequest
    class FatalWarning < RuntimeError
    end

    class FatalWarner
      def puts(warning)
        raise FatalWarning, warning
      end

      def write(warning)
        raise FatalWarning, warning
      end

      def flush
      end

      def string
        ""
      end
    end

    DEFAULT_ENV = {
      RACK_INPUT        => StringIO.new,
      RACK_ERRORS       => StringIO.new,
    }.freeze

    def initialize(app)
      @app = app
    end

    # Make a GET request and return a MockResponse. See #request.
    def get(uri, opts = {})     request(GET, uri, opts)     end
    # Make a POST request and return a MockResponse. See #request.
    def post(uri, opts = {})    request(POST, uri, opts)    end
    # Make a PUT request and return a MockResponse. See #request.
    def put(uri, opts = {})     request(PUT, uri, opts)     end
    # Make a PATCH request and return a MockResponse. See #request.
    def patch(uri, opts = {})   request(PATCH, uri, opts)   end
    # Make a DELETE request and return a MockResponse. See #request.
    def delete(uri, opts = {})  request(DELETE, uri, opts)  end
    # Make a HEAD request and return a MockResponse. See #request.
    def head(uri, opts = {})    request(HEAD, uri, opts)    end
    # Make an OPTIONS request and return a MockResponse. See #request.
    def options(uri, opts = {}) request(OPTIONS, uri, opts) end

    # Make a request using the given request method for the given
    # uri to the rack application and return a MockResponse.
    # Options given are passed to MockRequest.env_for.
    def request(method = GET, uri = "", opts = {})
      env = self.class.env_for(uri, opts.merge(method: method))

      if opts[:lint]
        app = Rack::Lint.new(@app)
      else
        app = @app
      end

      errors = env[RACK_ERRORS]
      status, headers, body = app.call(env)
      MockRespons