html(path.sub(/^#{root}/, ''))
        yield(DIR_PAGE_HEADER % [ show_path, show_path ])

        unless path.chomp('/') == root
          yield(DIR_FILE % DIR_FILE_escape(files.call('..')))
        end

        Dir.foreach(path) do |basename|
          next if basename.start_with?('.')
          next unless f = files.call(basename)
          yield(DIR_FILE % DIR_FILE_escape(f))
        end

        yield(DIR_PAGE_FOOTER)
      end

      private

      # Escape each element in the array of html strings.
      def DIR_FILE_escape(htmls)
        htmls.map { |e| Utils.escape_html(e) }
      end
    end

    # The root of the directory hierarchy.  Only requests for files and
    # directories inside of the root directory are supported.
    attr_reader :root

    # Set the root directory and application for serving files.
    def initialize(root, app = nil)
      @root = ::File.expand_path(root)
      @app = app || Files.new(@root)
      @head = Head.new(method(:get))
    end

    def call(env)
      # strip body if this is a HEAD call
      @head.call env
    end

    # Internals of request handling.  Similar to call but does
    # not remove body for HEAD requests.
    def get(env)
      script_name = env[SCRIPT_NAME]
      path_info = Utils.unescape_path(env[PATH_INFO])

      if client_error_response = check_bad_request(path_info) || check_forbidden(path_info)
        client_error_response
      else
        path = ::File.join(@root, path_info)
        list_path(env, path, path_info, script_name)
      end
    end

    # Rack response to use for requests with invalid paths, or nil if path is valid.
    def check_bad_request(path_info)
      return if Utils.valid_path?(path_info)

      body = "Bad Request\n"
      [400, { CONTENT_TYPE => "text/plain",
        CONTENT_LENGTH => body.bytesize.to_s,
        "x-cascade" => "pass" }, [body]]
    end

    # Rack response to use for re