gems/gems/rack-3.0.8/lib/rack/headers.rb                                                            0000644                 00000005724 15040313410 0013443 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       module Rack
  # Rack::Headers is a Hash subclass that downcases all keys.  It's designed
  # to be used by rack applications that don't implement the Rack 3 SPEC
  # (by using non-lowercase response header keys), automatically handling
  # the downcasing of keys.
  class Headers < Hash
    def self.[](*items)
      if items.length % 2 != 0
        if items.length == 1 && items.first.is_a?(Hash)
          new.merge!(items.first)
        else
          raise ArgumentError, "odd number of arguments for Rack::Headers"
        end
      else
        hash = new
        loop do
          break if items.length == 0
          key = items.shift
          value = items.shift
          hash[key] = value
        end
        hash
      end
    end

    def [](key)
      super(downcase_key(key))
    end

    def []=(key, value)
      super(key.downcase.freeze, value)
    end
    alias store []=

    def assoc(key)
      su