    <h3 id="env-info">Rack ENV</h3>
          <table class="req">
            <thead>
              <tr>
                <th>Variable</th>
                <th>Value</th>
              </tr>
            </thead>
            <tbody>
                <% env.sort_by { |k, v| k.to_s }.each { |key, val| %>
                <tr>
                  <td><%=h key %></td>
                  <td class="code"><div><%=h val.inspect %></div></td>
                </tr>
                <% } %>
            </tbody>
          </table>

      </div>

      <div id="explanation">
        <p>
          You're seeing this error because you use <code>Rack::ShowExceptions</code>.
        </p>
      </div>

      </body>
      </html>
    HTML

    # :startdoc:
  end
end
                                                                                                                                                                                                                                                                                gems/gems/rack-3.0.8/lib/rack/recursive.rb                                                          0000644                 00000003436 15040313406 0014042 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

require 'uri'

require_relative 'constants'

module Rack
  # Rack::ForwardRequest gets caught by Rack::Recursive and redirects
  # the current request to the app at +url+.
  #
  #   raise ForwardRequest.new("/not-found")
  #

  class ForwardRequest < Exception
    attr_reader :url, :env

    def initialize(url, env = {})
      @url = URI(url)
      @env = env

      @env[PATH_INFO]       = @url.path
      @env[QUERY_STRING]    = @url.query  if @url.query
      @env[HTTP_HOST]       = @url.host   if @url.host
      @env[HTTP_PORT]       = @url.port   if @url.port
      @env[RACK_URL_SCHEME] = @url.scheme if @url.scheme

      super "forwarding to #{url}"
    end
  end

  # Rack::Recursive allows applications called down the chain to
  # include data from other applications (by using
  # <tt>rack['rack.recursive.include'][...]</tt> or raise a
  # ForwardRequest to redirect internally.

  class Recursive
    def initialize(app)
      @app = app
    end

    def call(env)
      dup._call(env)
    end

    def _call(env)
      @script_name = env[SCRIPT_NAME]
      @app.call(env.merge(RACK_RECURSIVE_INCLUDE => method(:include)))
    rescue ForwardRequest => req
      call(env.merge(req.env))
    end

    def include(env, path)
      unless path.index(@script_name) == 0 && (path[@script_name.size] == ?/ ||
                                               path[@script_name.size].nil?)
        raise ArgumentError, "can only include below #{@script_name}, not #{path}"
      end

      env = env.merge(PATH_INFO => path,
                      SCRIPT_NAME => @script_name,
                      REQUEST_METHOD => GET,
                      "CONTENT_LENGTH" => "0", "CONTENT_TYPE" => "",
                      RACK_INPUT => StringIO.new(""))
      @app.call(env)
    end
  end
end
                                                                                                                                                                                                                                  gems/gems/rack-3.0.8/lib/rack/tempfile_reaper.rb                                                    0000644                 00000001412 15040313407 0015167 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

require_relative 'constants'
require_relative 'body_proxy'

module Rack

  # Middleware tracks and cleans Tempfiles created throughout a request (i.e. Rack::Multipart)
  # Ideas/strategy based on posts by Eric Wong and Charles Oliver Nutter
  # https://groups.google.com/forum/#!searchin/rack-devel/temp/rack-devel/brK8eh-MByw/sw61oJJCGRMJ
  class TempfileReaper
    def initialize(app)
      @app = app
    end

    def call(env)
      env[RACK_TEMPFILES] ||= []

      begin
        _, _, body = response = @app.call(env)
      rescue Exception
        env[RACK_TEMPFILES]&.each(&:close!)
        raise
      end

      response[2] = BodyProxy.new(body) do
        env[RACK_TEMPFILES]&.each(&:close!)
      end

      response
    end
  end
end
                                                                                                                                                                                                                                                      gems/gems/rack-3.0.8/lib/rack/rewindable_input.rb                                                   0000644                 00000006176 15040313407 0015373 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # -*- encoding: binary -*-
# frozen_string_literal: true