ing not safe as path could contain glob metacharacters
      body = DirectoryBody.new(@root, path, ->(basename) do
        stat = stat(::File.join(path, basename))
        next unless stat

        url = ::File.join(*url_head + [Utils.escape_path(basename)])
        mtime = stat.mtime.httpdate
        if stat.directory?
          type = 'directory'
          size = '-'
          url << '/'
          if basename == '..'
            basename = 'Parent Directory'
          else
            basename << '/'
          end
        else
          type = Mime.mime_type(::File.extname(basename))
          size = filesize_format(stat.size)
        end

        [ url, basename, size, type, mtime ]
      end)

      [ 200, { CONTENT_TYPE => 'text/html; charset=utf-8' }, body ]
    end

    # File::Stat for the given path, but return nil for missing/bad entries.
    def stat(path)
      ::File.stat(path)
    rescue Errno::ENOENT, Errno::ELOOP
      return nil
    end

    # Rack response to use for files and directories under the root.
    # Unreadable and non-file, non-directory entries will get a 404 response.
    def list_path(env, path, path_info, script_name)
      if (stat = stat(path)) && stat.readable?
        return @app.call(env) if stat.file?
        return list_directory(path_info, path, script_name) if stat.directory?
      end

      entity_not_found(path_info)
    end

    # Rack response to use for unreadable and non-file, non-directory entries.
    def entity_not_found(path_info)
      body = "Entity not found: #{path_info}\n"
      [404, { CONTENT_TYPE => "text/plain",
        CONTENT_LENGTH => body.bytesize.to_s,
        "x-cascade" => "pass" }, [body]]
    end

    # Stolen from Ramaze
    FILESIZE_FORMAT = [
      ['%.1fT', 1 << 40],
      ['%.1fG', 1 << 30],
      ['%.1fM', 1 << 20],
      ['%.1fK', 1 << 10],
    ]

    # Provide human readable file sizes
    def filesize_format(int)
      FILESIZE_FORMAT.each do |format, size|
        return format % (int.to_f / size) if int >= size
      end

      "#{int}B"
    end
  end
end
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        gems/gems/rack-3.0.8/lib/rack/reloader.rb                                                           0000644                 00000006027 15040313406 0013627 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

# Copyright (C) 2009-2018 Michael Fellinger <m.fellinger@gmail.com>
# Rack::Reloader is subject to the terms of an MIT-style license.
# See MIT-LICENSE or https://opensource.org/licenses/MIT.

require 'pathname'

module Rack

  # High performant source reloader
  #
  # This class acts as Rack middleware.
  #
  # What makes it especially suited for use in a production environment is that
  # any file will only be checked once and there will only be made one system
  # call stat(2).
  #
  # Please note that this will not reload files in the background, it does so
  # only when actively called.
  #
  # It is performing a check/reload cycle at the start of every request, but
  # also respects a cool down time, during which nothing will be done.
  class Reloader
    def initialize(app, cooldown = 10, backend = Stat)
      @app = app
      @cooldown = cooldown
      @last = (Time.now - cooldown)
      @cache = {}
      @mtimes = {}
      @reload_mutex = Mutex.new

      extend backend
    end

    def call(env)
      if @cooldown and Time.now > @last + @cooldown
        if Thread.list.size > 1
          @reload_mutex.synchronize{ reload! }
        else
          reload!
        end

        @last = Time.now
      end

      @app.call(env)
    end

    def reload!(stderr = $stderr)
      rotation do |file, mtime|
        previous_mtime = @mtimes[file] ||= mtime
        safe_load(file, mtime, stderr) if mtime > previous_mtime
      end
    end

    # A safe Kernel::load, issuing the hooks depending on the results
    def safe_load(file, mtime, stderr = $stderr)
      load(file)
      stderr.puts "#{self.class}: reloaded `#{file}'"
      file
    rescue LoadError, SyntaxError => ex
      stderr.puts ex
    ensure
      @mtimes[file] = mtime
    end

    module Stat
      def rotation
        files = [$0, *$LOADED_FEATURES].uniq
        paths = ['./', *$LOAD_PATH].uniq

        files.map{|file|
          next if /\.(so|bundle)$/.match?(file) # cannot reload compiled files

          found, stat = figure_path(file, paths)
          next unless found && stat && mtime = stat.mtime

          @cache[file] = found

          yield(found, mtime)
        }.compact
      end

      # Takes a relative or absolute +file+ name, a couple possible +paths+ that
      # the +file+ might reside in. Returns the full path and File::Stat for the
      # path.
      def figure_path(file, paths)
        found = @cache[file]
        found = file if !found and Pathname.new(file).absolute?
        found, stat = safe_stat(found)
        return found, stat if found

        paths.find do |possible_path|
          path = ::File.join(possible_path, file)
          found, stat = safe_stat(path)
          return ::File.expand_path(found), stat if found
        end

        return false, false
      end

      def safe_stat(file)
        return unless file
        stat = ::File.stat(file)
        return file, stat if stat.file?
      rescue Errno::ENOENT, Errno::ENOTDIR, Errno::ESRCH
        @cache.delete(file) and false
    