# Rackup

`rackup` provides a command line interface for running a Rack-compatible application.

[![Development Status](https://github.com/rack/rackup/workflows/Test/badge.svg)](https://github.com/rack/rackup/actions?workflow=Test)

## Installation

``` bash
$ gem install rackup
```

## Usage

In a directory with your `config.ru` simply run the command:

``` bash
$ rackup
```

Your application should now be available locally, typically `http://localhost:9292`.

## Contributing

We welcome contributions to this project.

1.  Fork it.
2.  Create your feature branch (`git checkout -b my-new-feature`).
3.  Commit your changes (`git commit -am 'Add some feature'`).
4.  Push to the branch (`git push origin my-new-feature`).
5.  Create new Pull Request.
                                                                                                                                                                                                                                                                           gems/gems/rackup-2.1.0/lib/rackup/version.rb                                                        0000644                 00000000224 15040313405 0014411 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

# Released under the MIT License.
# Copyright, 2022-2023, by Samuel Williams.

module Rackup
  VERSION = "2.1.0"
end
                                                                                                                                                                                                                                                                                                                                                                            gems/gems/rackup-2.1.0/lib/rackup/handler/cgi.rb                                                    0000644                 00000002510 15040313405 0015103 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

# Released under the MIT License.
# Copyright, 2022-2023, by Samuel Williams.

module Rackup
  module Handler
    class CGI
      include Rack

      def self.run(app, **options)
        $stdin.binmode
        serve app
      end

      def self.serve(app)
        env = ENV.to_hash
        env.delete "HTTP_CONTENT_LENGTH"

        env[SCRIPT_NAME] = ""  if env[SCRIPT_NAME] == "/"

        env.update(
          RACK_INPUT        => $stdin,
          RACK_ERRORS       => $stderr,
          RACK_URL_SCHEME   => ["yes", "on", "1"].include?(ENV[HTTPS]) ? "https" : "http"
        )

        env[QUERY_STRING] ||= ""
        env[REQUEST_PATH] ||= "/"

        status, headers, body = app.call(env)
        begin
          send_headers status, headers
          send_body body
        ensure
          body.close  if body.respond_to? :close
        end
      end

      def self.send_headers(status, headers)
        $stdout.print "Status: #{status}\r\n"
        headers.each { |k, vs|
          vs.split("\n").each { |v|
            $stdout.print "#{k}: #{v}\r\n"
          }
        }
        $stdout.print "\r\n"
        $stdout.flush
      end

      def self.send_body(body)
        body.each { |part|
          $stdout.print part
          $stdout.flush
        }
      end
    end

    register :cgi, CGI
  end
end
                                                                                                                                                                                        gems/gems/rackup-2.1.0/lib/rackup/handler/webrick.rb                                                0000644                 00000010372 15040313405 0015774 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

# Released under the MIT License.
# Copyright, 2022-2023, by Samuel Williams.
# Copyright, 2022, by Jeremy Evans.

require 'webrick'
require 'stringio'

require 'rack/constants'
require_relative '../handler'
require_relative '../version'

require_relative '../stream'

module Rackup
  module Handler
    class WEBrick < ::WEBrick::HTTPServlet::AbstractServlet
      def self.run(app, **options)
        environment  = ENV['RACK_ENV'] || 'development'
        default_host = environment == 'development' ? 'localhost' : nil

        if !options[:BindAddress] || options[:Host]
          options[:BindAddress] = options.d