d_root!
      @settings = nil
      @root = nil
    end

    def reset_paths!
      @bin_path = nil
      @bundler_major_version = nil
      @bundle_path = nil
      @configure = nil
      @configured_bundle_path = nil
      @definition = nil
      @load = nil
      @locked_gems = nil
      @root = nil
      @settings = nil
      @setup = nil
      @user_home = nil
    end

    def reset_rubygems!
      return unless defined?(@rubygems) && @rubygems
      rubygems.undo_replacements
      rubygems.reset
      @rubygems = nil
    end

    def configure_gem_home_and_path(path = bundle_path)
      configure_gem_path
      configure_gem_home(path)
      Bundler.rubygems.clear_paths
    end

    def self_manager
      @self_manager ||= begin
                          require_relative "bundler/self_manager"
                          Bundler::SelfManager.new
                        end
    end

    private

    def load_marshal(data, marshal_proc: nil)
      Marshal.load(data, marshal_proc)
    rescue TypeError => e
      raise MarshalError, "#{e.class}: #{e.message}"
    end

    def eval_yaml_gemspec(path, contents)
      Kernel.require "psych"

      Gem::Specification.from_yaml(contents)
    rescue ::Psych::SyntaxError, ArgumentError, Gem::EndOfYAMLException, Gem::Exception
      eval_gemspec(path, contents)
    end

    def eval_gemspec(path, contents)
      eval(contents, TOPLEVEL_BINDING.dup, path.expand_path.to_s)
    rescue ScriptError, StandardError => e
      msg = "There was an error while loading `#{path.basename}`: #{e.message}"

      raise GemspecError, Dsl::DSLError.new(msg, path, e.backtrace, contents)
    end

    def configure_gem_path
      unless use_system_gems?
        # this needs to be empty string to cause
        # PathSupport.split_gem_path to only load up the
        # Bundler --path setting as the GEM_PATH.
        Bundler::SharedHelpers.set_env "GEM_PATH", ""
      end
    end

    def configure_gem_home(path)
      Bundler::SharedHelpers.set_env "GEM_HOME", path.to_s
    end

    def tmp_home_path
      Kernel.send(:require, "tmpdir")
      SharedHelpers.filesystem_access(Dir.tmpdir) do
        path = Bundler.tmp
        at_exit { Bundler.rm_rf(path) }
        path
      end
    end

    # @param env [Hash]
    def with_env(env)
      backup = ENV.to_hash
      ENV.replace(env)
      yield
    ensure
      ENV.replace(backup)
    end
  end
end
                                                                                                                                                     gems/gems/rackup-2.1.0/bin/rackup                                                                   0000755                 00000000151 15040313405 0012326 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       #!/usr/bin/env ruby
# frozen_string_literal: true

require_relative "../lib/rackup"
Rackup::Server.start
                                                          