oads the best available YAML library.

  def self.load_yaml
    begin
      gem 'psych'
    rescue NameError => e # --disable-gems
      raise unless e.name == :gem
    rescue Gem::LoadError
    end

    begin
      require 'psych'
    rescue ::LoadError
    ensure
      require 'yaml'
    end
  end

  def self.home
    rdoc_dir = begin
                File.expand_path('~/.rdoc')
              rescue ArgumentError
              end

    if File.directory?(rdoc_dir)
      rdoc_dir
    else
      begin
        # XDG
        xdg_data_home = ENV["XDG_DATA_HOME"] || File.join(File.expand_path("~"), '.local', 'share')
        unless File.exist?(xdg_data_home)
          FileUtils.mkdir_p xdg_data_home
        end
        File.join xdg_data_home, "rdoc"
      rescue Errno::EACCES
      end
    end
  end

  autoload :RDoc,           "#{__dir__}/rdoc/rdoc"

  autoload :CrossReference, "#{__dir__}/rdoc/cross_reference"
  autoload :ERBIO,          "#{__dir__}/rdoc/erbio"
  autoload :ERBPartial,     "#{__dir__}/rdoc/erb_partial"
  autoload :Encoding,       "#{__dir__}/                                                                                                                                                                                                                                                                                                                                                                                                                                                                                gems/gems/rdoc-6.5.1.1/lib/rdoc/context/section.rb                                                  0000644                 00000011301 15040313414 0015326 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       nstructs that appear in Ruby
  # programs: classes, modules, methods, and so on.
  autoload :CodeObject,     "#{__dir__}/rdoc/code_object"

  autoload :Context,        "#{__dir__}/rdoc/context"
  autoload :TopLevel,       "#{__dir__}/rdoc/top_level"

  autoload :AnonClass,      "#{__dir__}/rdoc/anon_class"
  autoload :ClassModule,    "#{__dir__}/rdoc/class_module"
  autoload :NormalClass,    "#{__dir__}/rdoc/normal_class"
  autoload :NormalModule,   "#{__dir__}/rdoc/normal_module"
  autoload :SingleClass,    "#{__dir__}/rdoc/single_class"

  autoload :Alias,          "#{__dir__}/rdoc/alias"
  autoload :AnyMethod,      "#{__dir__}/rdoc/any_method"
  autoload :MethodAttr,     "#{__dir__}/rdoc/method_attr"
  autoload :GhostMethod,    "#{__dir__}/rdoc/ghost_method"
  autoload :MetaMethod,     "#{__dir__}/rdoc/meta_method"
  autoload :Attr,           "#{__dir__}/rdoc/attr"

  autoload :Constant,       "#{__dir__}/rdoc/constant"
  autoload :Mixin,          "#{__dir__}/rdoc/mixin"                                                                                                                                                                                                                                                                                                                                                           gems/gems/rake-13.0.6/History.rdoc                                                                  0000644                 00000215222 15040313415 0012411 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       #!/opt/alt/ruby32/bin/ruby

#--
# Copyright (c) 2003, 2004, 2005, 2006, 2007  Jim Weirich
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to
# deal in the Software without restriction, including without limitation the
# rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
# sell copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
# IN THE SOFTWARE.
#++

require "rake"

Rake.application.run
                                                                                                                                                                                                                                                                                                                                                           gems/gems/rake-13.0.6/History.rdoc                                                                  0000644                 00000215222 15040313415 0012411 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       === 13.0.6

* Additional fix for #389
  Pull request #390 by hsbt

=== 13.0.5

* Fixed the regression of #388
  Pull request #389 by hsbt

=== 13.0.4

* Fix rake test loader swallowing useful error information.
  Pull request #367 by deivid-rodriguez
* Add -C/--directory option the same as GNU make.
  Pull request #376 by nobu

=== 13.0.3

* Fix breaking change of execution order on TestTask.
  Pull request #368 by ysakasin

=== 13.0.2

==== Enhancements

* Fix tests to work with current FileUtils
  Pull Request #358 by jeremyevans
* Simplify default rake test loader
  Pull Request #357 by deivid-rodriguez
* Update rdoc
  Pull Request #366 by bahasalien
* Update broken links to rake articles from Avdi in README
  Pull Request #360 by svl7

=== 13.0.1

==== Bug fixes

* Fixed bug: Reenabled task raises previous exception on second invokation 
  Pull Request #271 by thorsteneckel
* Fix an incorr                                                                                                                                                                                                                                                                                                                               gems/gems/rdoc-6.5.1.1/lib/rdoc/code_objects.rb                                                     0000644                 00000000242 15040313414 0014623 0                                                                                                    ustar 00                                                                                                                                                                                                                                                        jsm
* Add alias `prereqs`.
  Pull Request #268 by take-cheeze

=== 12.3.1

==== Bug fixes

* Support did_you_mean >= v1.2.0 which has a breaking change on format                                                                                                                                                                                                                                                                                                                                                              gems/gems/rdoc-6.5.1.1/lib/rdoc/ghost_method.rb                                                     0000644                 00000000220 15040313414 0014660 0                                        