l file in the file system,
it makes little sense to include file task names in name space.
Directory tasks (created by the +directory+ command) are a type of
file task and are also not affected by namespaces.

=== Name Resolution

When looking up a task name, rake will start with the current
namespace and attempt to find the name there.  If it fails to find a
name in the current namespace, it will search the parent namespaces
until a match is found (or an error occurs if there is no match).

The "rake" namespace is a special implicit namespace that refers to
the toplevel names.

If a task name begins with a "^" character, the name resolution will
start in the parent namespace.  Multiple "^" characters are allowed.

Here is an example file with multiple :run tasks and how various names
resolve in different locations.

  task :run

  namespace "one" do
    task :run

    namespace "two" do
      task :run

      # :run            => "one:two:run"
      # "two:run"       => "one:two:run"
      # "one:two:run"   => "one:two:run"
      # "one:run"       => "one:run"
      # "^run"          => "one:run"
      # "^^run"         => "rake:run" (the top level task)
      # "rake:run"      => "rake:run" (the top level task)
    end

    # :run       => "one:run"
    # "two:run"  => "one:two:run"
    # "^run"     => "rake:run"
  end

  # :run           => "rake:run"
  # "one:run"      => "one:run"
  # "one:two:run"  => "one:two:run"

== FileLists

FileLists are the way Rake manages lists of files.  You can treat a
FileList as an array of strings for the most part, but FileLists
support some additional operations.

=== Creating a FileList

Creating a file list is easy.  Just give it the list of file names:

   fl = FileList['file1.rb', file2.rb']

Or give it a glob pattern:

   fl = FileList['*.rb']

== Odds and Ends

=== do/end versus { }

Blocks may be specified with either a +do+/+end+ pair, or with curly
braces in Ruby.  We _strongly_ recommend using +do+/+end+ to specify the
actions for tasks and rules.  Because the rakefile idiom tends to
leave off parentheses on the task/file/rule methods, unusual
ambiguities can arise when using curly braces.

For example, suppose that the method +object_files+ returns a list of
object files in a project.  Now we use +object_files+ as the
prerequisites in a rule specified with actions in curly braces.

  # DON'T DO THIS!
  file "prog" => object_files {
    # Actions are expected here (but it doesn't work)!
  }

Because curly braces have a higher precedence than +do+/+end+, the
block is associated with the +obje                                                                                                                                                                                                                                                                                              gems/gems/rake-13.0.6/README.rdoc                                                                   0000644                 00000011535 15040313415 0011706 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                gems/gems/rdoc-6.5.1.1/lib/rdoc/constant.rb                                                         0000644                 00000007135 15040313414 0014041 0                                                                                                    ustar 00