ammatically manipulate tasks gives rake very
powerful meta-programming capabilities w.r.t. task execution, but
should be used with caution.

== Rules

When a file is named as a prerequisite, but does not have a file task
defined for it, Rake will attempt to synthesize a task by looking at a
list of rules supplied in the Rakefile.

Suppose we were trying to invoke task "mycode.o", but no task is
defined for it.  But the rakefile has a rule that look like this ...

  rule '.o' => ['.c'] do |t|
    sh "cc #{t.source} -c -o #{t.name}"
  end

This rule will synthesize any task that ends in ".o".  It has a
prerequisite a source file with an extension of ".c" must exist.  If
Rake is able to find a file named "mycode.c", it will automatically
create a task that builds "mycode.o" from "mycode.c".

If the file "mycode.c" does not exist, rake will attempt
to recursively synthesize a rule for it.

When a task is synthesized from a rule, the +source+ attribute of the
task is set to the matching source file.  This allows us to write
rules with actions that reference the source file.

=== Advanced Rules

Any regular expression may be used as the rule pattern.  Additionally,
a proc may be used to calculate the name of the source file.  This
allows for complex patterns and sources.

The following rule is equivalent to the example above.

  rule( /\.o$/ => [
    proc {|task_name| task_name.sub(/\.[^.]+$/, '.c') }
  ]) do |t|
    sh "cc #{t.source} -c -o #{t.name}"
  end

*NOTE:* Because of a _quirk_ in Ruby syntax, parenthesis are
required on *rule* when the first argument is a regular expression.

The following rule might be used for Java files ...

  rule '.class' => [
    proc { |tn| tn.sub(/\.class$/, '.java').sub(/^classes\//, 'src/') }
  ] do |t|
    java_compile(t.source, t.name)
  end

*NOTE:* +java_compile+ is a hypothetical method that invokes the
java compiler.

== Importing Dependencies

Any ruby file (including other rakefiles) can be included with a
standard Ruby +require+ command.  The rules and declarations in the
required file are just added to the definitions already accumulated.

Becau                                                                                                                                                                                                                                                                                                                                                                                                                                                     gems/gems/rdoc-6.5.1.1/lib/rdoc/normal_module.rb                                                    0000644                 00000002672 15040313414 0015046 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       makedepend+ before
loading.

== Comments

Standard Ruby comments (beginning with "#") can be used anywhere it is
legal in Ruby source code, including comments for tasks and rules.
However, if you wish a task to be described using the "-T" switch,
then you need to use the +desc+ command to describe the task.

Example:

  desc "Create a distribution package"
  task package: %w[ ... ] do ... end

The "-T" switch (or "--tasks" if you like to spell things out) will
display a list of tasks that have a description.  If you use +desc+ to
describe your major tasks, you have a semi-automatic way of generatin