st night (during CSI!) I massaged the
code and cleaned it up a bit.  The result is a bare-bones replacement
for make in exactly 100 lines of code.

For the curious, you can see it at ...
* doc/proto_rake.rdoc

Oh, about the name.  When I wrote the example Ruby Make task on my
whiteboard, my coworker exclaimed "Oh! I have the perfect name: Rake ...
Get it?  Ruby-Make. Rake!"  He said he envisioned the tasks as leaves
and Rake would clean them up  ... or something like that.  Anyways, the
name stuck.

Some quick examples ...

A simple task to delete backup files ...

   task :clean do
     Dir['*~'].each {|fn| rm fn rescue nil}
   end

Note that task names are symbols (they are slightly easier to type
than quoted strings ... but you may use quoted string if you would
rather). Rake makes the methods of the FileUtils module directly
available, so we take advantage of the <tt>rm</tt> command.  Also note
the use of "rescue nil" to trap and ignore errors in the <tt>rm</tt>
command.

To run it, just type "rake clean".  Rake will automatically find a
Rakefile in the current directory (or above!) and will invoke the
targets named on the command line.  If there are no targets explicitly
named, rake will invoke the task "default".

Here's another task with dependencies ...

   task :clobber => [:clean] do
     rm_r "tempdir"
   end

Task :clobber depends upon task :clean, so :clean will be run be                                                                                                                                                                                                                                                                                                                                                                                                                                                        gems/gems/rake-13.0.6/doc/rakefile.rdoc                                                             0000644                 00000050342 15040313415 0013277 0                                                                                                    ustar 00                                                                                                                                                                                                                                                            c_source_file(fn)
   end

where "c_source_file" will create all the tasks need to compile all the
C source files in a directory.  Any number of useful libraries could be
created for rake.

That's it.  There's no documentation (other than whats in this
message).  Does this sound interesting to anyone?  If so, I'll continue
to clean it up and write it up and publish it on RAA.  Otherwise, I'll
leave it as an interesting exercise and a tribute to the power of Ruby.

Why /might/ rake be interesting to Ruby programmers.  I don't know,
perhaps ...

* No weird make syntax (only weird Ruby syntax :-)
* No need to edit or read XML (a la ant)
* Platform independent build scripts.
* Will run anywhere Ruby exists, so no need to have "make" installed.
  If you stay away from the "sys" command and use things like
  'ftools', you can have a perfectly platform independent
  build script.  Also rake is only 100 lines of code, so it can
  easily be packaged along with the rest of your code.

So ... Sorry for the long rambling message.  Like I said, I never
intended to write this code at all.
                                                                                                                                                                                                                                                                                                                                                                                                                                                        gems/gems/rake-13.0.6/doc/rakefile.rdoc                                                             0000644                 00000050342 15040313415 0013277 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       = Rakefile Format

First of all, there is no special format for a Rakefile.  A Rakefile
contains executable Ruby code.  Anything legal in a ruby script is
allowed in a Rakefile.

Now that we understand there is no special syntax in a Rakefile, there
are some conventions that are used in a Rakefile that are a little
unusual in a typical Ruby program.  Since a Rakefile is tailored to
specifying tasks and actions, the idioms used in a Rakefile are
designed to support that.

So, what goes into a Rakefile?

== Tasks

Tasks are the main unit of work in a Rakefile.  Tasks have a name
(usually given as a symbol or a string), a list of prerequisites (more
symbols or strings) and a list of actions (given as a block).

=== Simple Tasks

A task is declared by using the +task+ method.  +task+ takes a single
parameter that is the name of the task.

  task :name

=== Tasks with Prerequisites

Any prerequisites are given as a list (enclosed in square brackets)
following the name and an arrow (=>).

  task name: [:prereq1, :prereq2]

*NOTE:* Although this syntax looks a little funky, it is legal
Ruby.  We are constructing a hash where the key is :name and the value
for that key is the list of prerequisites.  It is equivalent to the
following ...

  hash = Hash.new
  hash[:name] = [:prereq1, :prereq2]
  task(hash)

You can also use strings for task names and prerequisites, rake doesn't care.
This is the same task definition:

  task 'name' => %w[prereq1 prereq2]

As is this:

  task name: %w[prereq1 prereq2]

We'll prefer this style for regular tasks with prerequisites throughout the
rest of the document.  Using an array of strings for the prerequisites means
you will need to make fewer changes if you need to move tasks into namespaces
or perform other refactorings.

=== Tasks with Actions

Actions are defined by passing a block to the +task+ method.  Any Ruby
code can be placed in the block.  The block may reference the task
object via the block parameter.

  task name: [:prereq1, :prereq2] do |t|
    # actions (may reference t)
  end

=== Multiple Definitions

A task may be specified more than once.  Each specification adds its
prerequisites and actions to the existing definition.  This allows one
part of a rakefile to specify the actions and a different rakefile
(perhaps separately generated) to specify the dependencies.

For example, the following is equivalent to the single task
specification given above.

  task :name
  task name: :prereq1
  task name: %w[prereq2]
  task :name do |t|
    # actions
  end

== File Tasks

Some tasks are designed to create a file from one or more other files.
Tasks that generate these files may be skipped if the file already
exists.  File tasks are used to specify file creation tasks.

File tasks are declared using the +file+ method (instead of the +task+
method).  In