d line.  The problem is that there was no
easy way to associate positional arguments on the command line with
different tasks.  Suppose both tasks :a and :b expect a command line
argument: does the first value go with :a?  What if :b is run first?
Should it then get the first command line argument.

Rake 0.8.0 solves this problem by explicitly passing values directly
to the tasks that need them.  For example, if I had a release task
that required a version number, I could say:

   rake release[0.8.2]

And the string "0.8.2" will be passed to the :release task.  Multiple
arguments can be passed by separating them with a comma, for example:

   rake name[john,doe]

Just a few words of caution.  The rake task name and its arguments
need to be a single command line argument to rake.  This generally
means no spaces.  If spaces are needed, then the entire name +
argument string should be quoted.  Something like this:

   rake "name[billy bob, smith]"

(Quoting rules vary between operating systems and shells, so make sure
you consult the proper docs for your OS/shell).

=== Tasks that Expect Parameters

Parameters are only given to tasks that are setup to expect them.  In
order to handle named parameters, the task declaration syntax for
tasks has been extended slightly.

For example, a task that needs a first name and last name might be
declared as:

   task :name, [:first_name, :last_name]

The first argument is still the name of the task (:name in this case).
The next two arguments are the names of the parameters expected by
:name in an array (:first_name and :last_name in the example).

To access the values of the parameters, the block defining the task
behaviour can now accept a second parameter:

   task :name, [:first_name, :last_name] do |t, args|
     puts "First name is #{args.first_name}"
     puts "Last  name is #{args.last_name}"
   end

The first argument of the block "t" is always bound to the current
task object.  The second argument "args" is an open-struct like object
that allows access to the task arguments.  Extra command line
arguments to a task are ignored.

If you wish to specify default values for the arguments, you can use
the with_defaults method in the task body.  Here is the above example
where we specify default values for the first and last names:

   task :name, [:first_name, :last_name] do |t, args|
     args.with_defaults(:first_name => "John", :last_name => "Dough")
     puts "First name is #{args.first_name}"
     puts "Last  name is #{args.last_name}"
   end

=== Tasks that Expect Parameters and Have Prerequisites

Tasks that use parameters have a slightly different format for
prerequisites.  Use the arrow notation to indicate the prerequisites
for tasks with arguments.  For example:

   task :name, [:first_name, :last_name] => [:pre_name] do |t, args|
     args.with_defaults(:first_name => "John", :last_name => "Dough")
     puts "First name is #{args.first_name}"
     puts "Last  name is #{args.last_name}"
   end

=== Tasks that take Variable-length Parameters

Tasks that need to handle a list of values as a parameter can use the
extras method of the args variable.  This allows for tasks that can
loop over a variable number of values, and its compatible with named
parameters as well:

   task :email, [:message] do |t, args|
     mail = Mail.new(args.message)
     recipients = args.extras
     recipients.each do |target|
       mail.send_to(target)
     end
   end

There is also the convenience method to_a that returns all parameters
in the sequential order they were given, including those associated
with named parameters.

=== Deprecated Task Parameters Format

There is an older format for declaring task parameters that omitted
the task argument array and used the :needs keyword to introduce the
dependencies.  That format is still support