y class can collect tokens by including TokenStream. From the
# outside, you use such an object by calling the start_collecting_tokens
# method, followed by calls to add_token and pop_token.

module RDoc::TokenStream

  ##
  # Converts +token_stream+ to HTML wrapping various tokens with
  # <tt><span></tt> elements. Some tokens types are wrapped in spans
  # with the given class names. Other token types are not wrapped in spans.

  def self.to_html token_stream
    starting_title = false

    token_stream.map do |t|
      next unless t

      style = case t[:kind]
              when :on_const   then 'ruby-constant'
              when :on_kw      then 'ruby-keyword'
              when :on_ivar    then 'ruby-ivar'
              when :on_cvar    then 'ruby-identifier'
              when :on_gvar    then 'ruby-identifier'
              when '=' != t[:text] && :on_op
                               then 'ruby-operator'
              when :on_tlambda then 'ruby-operator'
                                                                                                                                                                                                                                                                                                                                                                    gems/gems/rdoc-6.5.1.1/lib/rdoc/top_level.rb                                                        0000644                 00000013055 15040313414 0014177 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       ][-1]
        text =