on
      }
    else
      array.reject! { |e|
        e.visibility == :private and not e.force_documentation
      }
    end
  end

  ##
  # Tries to resolve unmatched aliases when a method or attribute has just
  # been added.

  def resolve_aliases added
    # resolve any pending unmatched aliases
    key = added.pretty_name
    unmatched_alias_list = @unmatched_alias_lists[key]
    return unless unmatched_alias_list
    unmatched_alias_list.each do |unmatched_alias|
      added.add_alias unmatched_alias, self
      @external_aliases.delete unmatched_alias
    end
    @unmatched_alias_lists.delete key
  end

  ##
  # Returns RDoc::Context::Section objects referenced in this context for use
  # in a table of contents.

  def section_contents
    used_sections = {}

    each_method do |method|
      next unless method.display?

      used_sections[method.section] = true
    end

    # order found sections
    sections = sort_sections.select do |section|
      used_sections[section]
    end

    # only the default section is used
    return [] if
      sections.length == 1 and not sections.first.title

    sections
  end

  ##
  # Sections in this context

  def sections
    @sections.values
  end

  def sections_hash # :nodoc:
    @sections
  end

  ##
  # Sets the current section to a section with +title+.  See also #add_section

  def set_current_section title, comment
    @current_section = add_section title, comment
  end

  ##
  # Given an array +methods+ of method names, set the visibility of each to
  # +visibility+

  def set_visibil