# frozen_string_literal: true
##
# A PO entry in PO

class RDoc::Generator::POT::POEntry

  # The msgid content
  attr_reader :msgid

  # The msgstr content
  attr_reader :msgstr

  # The comment content created by translator (PO editor)
  attr_reader :translator_comment

  # The comment content extracted from source file
  attr_reader :extracted_comment

  # The locations where the PO entry is extracted
  attr_reader :references

  # The flags of the PO entry
  attr_reader :flags

  ##
  # Creates a PO entry for +msgid+. Other valus can be specified by
  # +options+.

  def initialize msgid, options = {}
    @msgid = msgid
    @msgstr = options[:msgstr] || ""
    @translator_comment = options[:translator_comment]
    @extracted_comment = options[:extracted_comment]
    @references = options[:references] || []
    @flags = options[:flags] || []
  end

  ##
  # Returns the PO entry in PO format.

  def to_s
    entry = ''
    entry += format_translator_comment
    entry += format_extracted_comment
    entry += format_references
    entry += format_flags
    entry += <<-ENTRY
msgid #{format_message(@msgid)}
msgstr #{format_message(@msgstr)}
    ENTRY
  end

  ##
  # Merges the PO entry with +other_entry+.

  def merge other_entry
    options = {
      :extracted_comment  => merge_string(@extracted_comment,
                                          other_entry.extracted_comment),
      :translator_comment => merge_string(@translator_comment,
                                          other_entry.translator_comment),
      :references         => merge_array(@references,
                                         other_entry.references),
      :flags              => merg