gems/gems/rdoc-6.5.1.1/lib/rdoc/generator/pot/po.rb                                                 0000644                 00000003233 15040313412 0015407 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       /*
 * Navigation allows movement using the arrow keys through the search results.
 *
 * When using this library you will need to set scrollIntoView to the
 * appropriate function for your layout.  Use scrollInWindow if the container
 * is not scrollable and scrollInElement if the container is a separate
 * scrolling region.
 */
Navigation = new function() {
  this.initNavigation = function() {
    var _this = this;

    document.addEventListener('keydown', function(e) {
      _this.onkeydown(e);
    });

    this.navigationActive = true;
  }

  this.setNavigationActive = function(state) {
    this.navigationActive = state;
  }

  this.onkeydown = function(e) {
    if (!this.navigationActive) return;
    switch(e.keyCode) {
      case 37: //Event.KEY_LEFT:
        if (this.moveLeft()) e.preventDefault();
        break;
      case 38: //Event.KEY_UP:
        if (e.keyCode == 38 || e.ctrlKey) {
          if (this.moveUp()) e.preventDefault();
        }
        break;
      case 39: //Event.KEY_RIGHT:
        if (this.moveRight()) e.preventDefault();
        break;
      case 40: //Event.KEY_DOWN:
        if (e.keyCode == 40 || e.ctrlKey) {
          if (this.moveDown()) e.preventDefault();
        }
        break;
      case 13: //Event.KEY_RETURN:
        if (this.current) e.preventDefault();
        this.select(this.current);
        break;
    }
    if (e.ctrlKey && e.shiftKey) this.select(this.current);
  }

  this.moveRight = function() {
  }

  this.moveLeft = function() {
  }

  this.move = function(isDown) {
  }

  this.moveUp = function() {
    return this.move(false);
  }

  this.moveDown = function() {
    return this.move(true);
  }

  /*
   * Scrolls to                                                                                                                                                                                                                                                                                                                                                                     gems/gems/rdoc-6.5.1.1/lib/rdoc/generator/pot.rb                                                    0000644                 00000004377 15040313412 0015003 0                                                                                                    ustar 00                                                                                                                                                                                                                                                           window.scrollTo(window.scrollX, offset - viewHeight + height);
    }
    if (offset < viewScroll) {
      window.scrollTo(window.scrollX, offset);
    }
  }
}

                                                                                                                                                                                                                                                                                                                                                            gems/gems/rdoc-6.5.1.1/lib/rdoc/generator/template/json_index/js/searcher.js                        0000644                 00000014704 15040313412 0022370 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       Searcher = function(data) {
  this.data = data;
  this.handlers = [];
}

Searcher.prototype = new function() {
  // search is performed in chunks of 1000 for non-blocking user input
  var CHUNK_SIZE = 1000;
  // do not try to find more than 100 results
  var MAX_RESULTS = 100;
  var huid = 1;
  var suid = 1;
  var runs = 0;

  this.find = function(query) {
    var queries = splitQuery(query);
    var regexps = buildRegexps(queries);
    var highlighters = buildHilighters(queries);
    var state = { from: 0, pass: 0, limit: MAX_RESULTS, n: suid++};
    var _this = this;

    this.currentSuid = state.n;

    if (!query) return;

    var run = function() {
      // stop current search thread if new search started
      if (state.n != _this.currentSuid) return;

      var results =
        performSearch(_this.data, regexps, queries, highlighters, state);
      var hasMore = (state.limit > 0 && state.pass < 4);

      triggerResults.call(_this, results, !hasMore);
      if (hasMore) {
        setTimeout(run, 2);
      }
      runs++;
    };
    runs = 0;

    // start search thread
    run();
  }

  /*  ----- Events ------  */
  this.ready = function(fn) {
    fn.huid = huid;
    this.handlers.push(fn);
  }

  /*  ----- Utilities ------  */
  function splitQuery(q                                                                                                                                                                                                                                                                 gems/gems/rdoc-6.5.1.1/lib/rdoc/generator/template/json_index/js/navigation.js                      0000644                 00000005244 15040313412 0022732 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       s ------  */

  /*
   * This record matches if the index starts with queries[0] and the record
   * matches all of the regexps
   */
  function matchPassBeginning(index, longIndex, queries, regexps) {
    if (index.indexOf(queries[0]) != 0) return false;
    for (var i=1, l = regexps.length; i < l; i++) {
      if (!index.match(regexps[i]) && !longIndex.match(regexps[i]))
        return false;
    };
    return true;
  }

  /*
   * This record matc