 Rake updates in the 0.4.xx series as new
Ruby-1.8.2 issues become manifest.  Once the codebase stabilizes, I
will release a 0.5.0 version incorporating all the changes.  If you
are not using Ruby-1.8.2 and wish to avoid version churn, I recommend
staying with a release prior to Rake-0.4.14.

=== 0.4.14

Version 0.4.14 is a compatibility fix to allow Rake's test task to
work under Ruby 1.8.2.  A change in the Test::Unit autorun feature
prevented Rake from running any tests.  This release fixes the
problem.

Rake 0.4.14 is the recommended release for anyone using Ruby 1.8.2.

=== 0.4.13

* Fixed the dry-run flag so it is operating again.
* Multiple arguments to sh and ruby commands will not be interpreted
  by the shell (patch provided by Jonathan Paisley).

=== 0.4.12

* Added --silent (-s) to suppress the (in directory) rake message.

=== 0.4.11

* Changed the "don't know how to rake" message (finally)
* Changes references to a literal "Rakefile" to reference the global
  variable $rakefile (which contains the actual name of the rakefile).

=== 0.4.10

* Added block support to the "sh" command, allowing users to take
  special actions on the result of the system call.  E.g.

    sh "shell_command" do |ok, res|
      puts "Program returned #{res.exitstatus}" if ! ok
    end

=== 0.4.9

* Switched to Jamis Buck's RDoc template.
* Removed autorequire from Rake's gem spec.  This prevents the Rake
  libraries from loading while using rails.

=== 0.4.8

* Added support for .rb versions of Rakefile.
* Removed \\\n's from test task.
* Fixed Ruby 1.9 compatibility issue with FileList.

=== 0.4.7

* Fixed problem in FileList that caused Ruby 1.9 to go into infinite
  recursion.  Since to_a was removed from Object, it does not need to
  added back into the list of methods to rewrite in FileList.  (Thanks
  to Kent Sibilev for pointing this out).

=== 0.4.6
* Removed test version of ln in FileUtils that prevented safe_ln from
  using ln.

=== 0.4.5
* Upgraded comments in TestTask.
* FileList to_s and inspect now automatically resolve pending changes.
* FileList#exclude properly returns the FileList.

=== 0.4.4
* Fixed initialization problem with @comment.
* Now using multi -r technique in TestTask.  Switch Rakefile back to
  using the built-in test task macros because the rake runtime is no
  longer needed.
* Added 'TEST=filename' and 'TESTOPTS=options' to the Test Task
  macros.
* Allow a +test_files+ attribute in test tasks.  This allows more
  flexibility in specifying test files.

=== 0.4.3
* Fixed Comment leakage.

=== 0.4.2
* Added safe_ln that falls back to a copy if a file link is not supported.
* Package builder now uses safe\_ln.

=== 0.4.1
* Task comments are now additive, combined with "/".
* Works with (soon to be released) rubygems 0.6.2 (or 0.7.0)

=== 0.4.0
* FileList now uses deferred loading.  The file system is not searched
  until the first call that needs the file names.
* VAR=VALUE options are now accepted on the command line and are
  treated like env                                                                                                                                                                                                                                                                                                                                                                              gems/gems/rake-13.0.6/doc/command_line_usage.rdoc                                                   0000644                 00000013506 15040313415 0015327 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       ' attribute added

Package Task Library Issues

* Version (or explicit :noversion) is required.
* +package_file+ attribute is now writable

FileList Issues

* Dropped bang version of exclude.  Now using ant-like include/exclude semantics.
* Enabled the "yield self" idiom in FileList#initialize.

=== 0.2.9

This version contains numerous changes as the RubyConf.new(2003)
presentation was being prepared.  The changes include:

* The monolithic rubyapp task library is in the process of being
  dropped in favor of lighter weight task libraries.

=== 0.2.7

* Added "desc" for task descriptions.
* -T will now display tasks with descriptions.
* -P will display tasks and prerequisites.
* Dropped the Sys module in favor of the 1.8.x FileUtils module.  Sys
  is still supported in the contrib area.

=== 0.2.6

* Moved to RubyForge

=== 0.2.5

* Switched to standard ruby app builder.
* Added no_match option to file matcher.

=== 0.2.4

* Fixed indir, which neglected to actually change directories.

=== 0.2.3

* Added rake module for a help target
* Added 'for\_files' to Sys
* Added a $rakefile constant
* Added test for selecting proper rule with multiple targets.
                                                                                                                                                                                                                                                                                                                                                                              gems/gems/rake-13.0.6/doc/command_line_usage.rdoc                                                   0000644                 00000013506 15040313415 0015327 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       = Rake Command Line Usage

Rake is invoked from the command line using:

    % rake [options ...]  [VAR=VALUE ...]  [targets ...]

Options are:

[<tt><em>name</em>=<em>value</em></tt>]
    Set the environment variable <em>name</em> to <em>value</em>
    during the execution of the <b>rake</b> command.  You can access
    the value by using ENV['<em>name</em>'].

[<tt>--all</tt> (-A)]
    Used in combination with the -T and -D options, will force
    those options to show all the tasks, even the ones without comments.

[<tt>--backtrace</tt>{=_output_} (-n)]
    Enable a full backtrace (i.e. like --trace, but without the task
    tracing details). The _output_ parameter is optional, but if
    specified it controls where the backtrace output is sent. If
    _output_ is <tt>stdout</tt>, then backtrace output is directed to
    standard output. If _output_ is <tt>stderr</tt>, or if it is
    missing, then the backtrace output is sent to standard error.

[<tt>--comments</tt>]
    Used in combination with the -W options to force the output to
    contain commented options only. This is the reverse of
    <tt>--all</tt>.

[<tt>--describe</tt> _pattern_ (-D)]
    Describe the tasks (matching optional PATTERN), then exit.

[<tt>--dry-run</tt> (-n)]
    Do a dry run.  Print the tasks invoked and executed, but do not
    actually execute any of the actions.

[<tt>--execute</tt> _code_ (-e)]
    Execute some Ruby code and exit.

[<tt>--execute-print</tt> _code_ (-p)]
    Execute some Ruby code, print the result, and exit.

[<tt>--execute-continue</tt> _code_ (-E)]
    Execute some Ruby code, then continue with normal task processing.

[<tt>--help</tt>  (-H)]
    Display some help text and exit.

[<tt>--jobs</tt> _number_  (-j)]

    Specifies the maximum number of concurrent threads allowed. Rake
    will allocate threads as needed up to this maximum number.

    If omitted, Rake will attempt to estimate the number of CPUs on
    the system and add 4 to that number.

    The concurrent threads are used to execute the <tt>multitask</tt>
    prerequisites. Also see the <tt>-m</tt> option which turns all
    tasks into multitasks.

    Sample values:
       (no -j)   : Allow up to (# of CPUs + 4) number of threads
       --jobs    : Allow unlimited number of threads
       --jobs=1  : Allow only one thread (the main thread)
       --jobs=16 : Allow up to 16 concurrent threads

[<tt>--job-stats</tt> _level_]

    Display job statistics at the completion of the run. By default,
    this will display the requested number of active threads (from the
    -j options) and the maximum number of threads in play at any given
    time.

    If the optional _level_ is <tt>history</tt>, then a complete trace
    of task history will be displayed on standard output.

[<tt>                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               gems/gems/rdoc-6.5.1.1/lib/rdoc/markdown/literals.rb                                                0000644                 00000024367 15040313414 0015657 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       /tt> _name_ (-r)]
    Require _name_ before executing the Rakefile.

[<tt>--rules</tt>]
    Trace the rules resolution.

[<tt                                                                                                                                                                                          gems/gems/rake-13.0.6/doc/glossary.rdoc                                                             0000644                 00000003364 15040313415 0013362 0                                                                                                    ustar 00                                                                                                                                                                                       