ote
    tt_sections block_quote.text
  end

  ##
  # Pops the list type for +list+ from #list_type

  def accept_list_end list
    @list_type.pop
  end

  ##
  # Pushes the list type for +list+ onto #list_type

  def accept_list_start list
    @list_type << list.type
  end

  ##
  # Prepares the visitor for consuming +list_item+

  def accept_list_item_start list_item
    case @list_type.last
    when :NOTE, :LABEL then
      Array(list_item.label).map do |label|
        tt_sections label
      end.flatten
    end
  end

  ##
  # Adds +paragraph+ to the output

  def accept_paragraph paragraph
    tt_sections(paragraph.text)
  end

  ##
  # Does nothing to +markup_item+ because it doesn't have any user-built
  # content

  def do_nothing markup_item
  end

  alias accept_blank_line    do_nothing # :nodoc:
  alias accept_heading       do_nothing # :nodoc:
  alias accept_list_item_end do_nothing # :nodoc:
  alias accept_raw           do_nothing # :nodoc:
  alias accept_rule          do_nothing # :nodoc:
  alias accept_verbatim      do_nothing # :nodoc:

  ##
  # Extracts tt sections from +text+

  def tt_sections text
    flow = @am.flow text.dup

    flow.each do |item|
      case item
      when String then
        @res << item if in_tt?
      when RDoc::Markup::AttrChanger then
        off_tags res, item
        on_tags res, item
      when RDoc::Markup::RegexpHandling then
        @res << convert_regexp_handling(item) if in_tt? # TODO can this happen?
      else
        raise "Unknown flow element: #{item.inspect}"
      end
    end

    res
  end

  ##
  # Returns an Array of items that were wrapped in plus, tt or code.

  def end_accepting
    @res.compact
  end

  ##
  # Prepares the visitor for gathering tt sections

  def start_accepting
    @res = []

    @list_type = []
  end

end

                                                                                                                                                                                                                                  gems/gems/rdoc-6.5.1.1/lib/rdoc/markup/raw.rb                                                       0000644                 00000001750 15040313412 0014273 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true
##
# A section of text that is added to the output document as-is

class RDoc::Markup::Raw

  ##
  # The component parts of the list

  attr_reader :parts

  ##
  # Creates a new Raw containing +parts+

  def initialize *parts
    @parts = []
    @parts.concat parts
  end

  ##
  # Appends +text+

  def << text
    @parts << text
  end

  def == other # :nodoc:
    self.class == other.class and @parts == other.parts
  end

  ##
  # Calls #accept_raw+ on +visitor+

  def accept visitor
    visitor.accept_raw self
  end

  ##
  # Appends +other+'s parts

  def merge other
    @parts.concat other.parts
  end

  def pretty_print q # :nodoc:
    self.class.name =~ /.*::(\w{1,4})/i

    q.group 2, "[#{$1.downcase}: ", ']' do
      q.seplist @parts do |part|
        q.pp part
      end
    end
  end

  ##
  # Appends +texts+ onto this Paragraph

  def push *texts
    self.parts.concat texts
  end

  ##
  # The raw text

  def text
    @parts.join ' '
  end

end

                        gems/gems/rdoc-6.5.1.1/lib/rdoc/markup/attribute_manager.rb                                         0000644                 00000023744 15040313412 0017206 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: tr                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     gems/gems/rdoc-6.5.1.1/lib/rdoc/markup/to_tt_only.rb                                                0000644                 00000004436 15040313412 0015700 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       er :matching_word_pairs

  ##
  # And this is used when the delimiters aren't the same. In this case the
  # hash maps a pattern to the attribute character

  attr_reader :word_pair_map

  ##
  # This maps HTML tags to the corresponding attribute char

  attr_reader :html_tags

  ##
  # A \ in front of a character that would normally be processed turns off
  # processing. We do this by turning \< into <#{PROTECT}

  attr_reader :protectable

  ##
  # And this maps _regexp handling_ sequences to a name. A regexp handling
  # sequence is something like a WikiWord

  attr_reader :regexp_handlings

  ##
  # A bits of exclusive maps
  attr_reader :exclusive_bitmap

  ##
  # Creates a new attribute manager that understands bold, emphasized and
  # teletype text.

  def initialize
    @html_tags = {}
    @matching_word_pairs = {}
    @protectable = %w[<]
    @regexp_handlings = []
    @word_pair_map = {}
    @exclusive_bitmap = 0
    @attributes = RDoc::Markup::Attributes.new

    add_word_pair "*", "*", :BOLD, true
    add_word_pair "_", "_", :EM, true
    add_word_pair "+", "+", :TT, true

    add_html "em", :EM, true
    add_html "i",  :EM, true
    add_html "b",  :BOLD, true
    add_html "tt",   :TT, true
    add_html "code", :TT, true
  end

  ##
  # Return an attribute object with the given turn_on and turn_off bits set

  def attribute(turn_on, turn_off)
    RDoc::Markup::AttrChanger.new turn_on, turn_off
  end

  ##
  # Changes the current attribute from +current+ to +new+

  def change_attribute current, new
    diff = current ^ new
    attribute(new & diff, current & diff)
  end

  ##
  # Used by the tests to change attributes by name from +current_set+ to
  # +new_set+

  def changed_attribute_by_name current_set, new_set
    current = new = 0
    current_set.each do |name|
      current |= @attributes.bitmap_for(name)
    end

    new_set.each do |name|
      new |= @attributes.bitmap_for(name)
    end

    change_attribute(current, new)
  end

  ##
  # Copies +start_pos+ to +end_pos+ from the current string

  def copy_string(start_pos, end_pos)
    res = @str[start_pos...end_pos]
    res.gsub!(/\000/, '')
    res
  end

  def exclusive?(attr)
    (attr & @exclusive_bitmap) != 0
  end

  NON_PRINTING_START = "\1" # :nodoc:
  NON_PRINTING_END = "\2" # :nodoc:

  ##
  # Map attributes like                                                                                                                                                                                                                                  gems/gems/rdoc-6.5.1.1/lib/rdoc/markup/raw.rb                                                       0000644                 00000001750 15040313412 0014273 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       ?=#{all_tags}|\W|$)/

    1 while str.gsub!(re) { |orig|
      a, w = (m = $~).values_at(1, 2)
      attr = @matching_word_pairs[a]
      if attrs.set_attrs(m.begin(2), w.length, attr)
        a = NULL * a.length
      else
        a = NON_PRINTING_START + a + NON_PRINTING_END
      end
      a + w + a
    }
    str.delete!(NON_PRINTING_START + NON_PRINTING_END)
  end

  def convert_attrs_word_pair_map(str, attrs, exclusive)
    # then non-matching
    unless @word_pair_map.empty? then
      @word_pair_map.each do |regexp, attr|
        next unless exclusive == exclusive?(attr)
        1 while str.gsub!(regexp) { |orig|
          w = (m = ($~))[2]
          updated = attrs.set_attrs(m.begin(2), w.length, attr)
          if updated
            NULL * m.match_length(1) + w + NULL * m.match_length(3)
          else
            orig
          end
        }
      end
    end
  end

  ##
  # Converts HTML tags to RDoc attributes

  def convert_html(str, attrs, exclusive = false)
    tags = @                        gems/gems/rdoc-6.5.1.1/lib/rdoc/markup/attribute_manager.rb                                         0000644                 00000023744 15040313412 0017206 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       egexp, attribute|
      next unless exclusive == exclusive?(attribute)
      str.scan(regexp) do
        capture = $~.size == 1 ? 0 : 1

        s, e = $~.offset capture

        attrs.set_attrs s, e - s, attribute | @attributes.regexp_handling
      end
    end
  end

  ##
  # Escapes regexp handling sequences of text to prevent conversion to RDoc

  def mask_protected_sequences
    # protect __send__, __FILE__, etc.
    @str.gsub!(/__([a-z]+)__/i,
      "_#{PROTECT_ATTR}_#{PROT