s >= @character_limit
    input = verbatim.text.rstrip

    text = truncate input
    text << ' ...' unless text == input

    super RDoc::Markup::Verbatim.new text

    add_paragraph
  end

  ##
  # Prepares the visitor for HTML snippet generation

  def start_accepting
    super

    @characters = 0
  end

  ##
  # Removes escaping from the cross-references in +target+

  def handle_regexp_CROSSREF target
    target.text.sub(/\A\\/, '')
  end

  ##
  # +target+ is a <code><br></code>

  def handle_regexp_HARD_BREAK target
    @characters -= 4
    '<br>'
  end

  ##
  # Lists are paragraphs, but notes and labels have a separator

  def list_item_start list_item, list_type
    throw :done if @characters >= @character_limit

    case list_type
    when :BULLET, :LALPHA, :NUMBER, :UALPHA then
      "<p>"
    when :LABEL, :NOTE then
      labels = Array(list_item.label).map do |label|
        to_