# frozen_string_literal: true
##
# A Document containing lists, headings, paragraphs, etc.

class RDoc::Markup::Document

  include Enumerable

  ##
  # The file this document was created from.  See also
  # RDoc::ClassModule#add_comment

  attr_reader :file

  ##
  # If a heading is below the given level it will be omitted from the
  # table_of_contents

  attr_accessor :omit_headings_below

  ##
  # The parts of the Document

  attr_reader :parts

  ##
  # Creates a new Document with +parts+

  def initialize *parts
    @parts = []
    @parts.concat parts

                                                                                                                                                                                                                                                                                                                                                                                                                                                                           gems/gems/rdoc-6.5.1.1/lib/rdoc/markup/to_label.rb                                                  0000644                 00000003533 15040313412 0015264 0                                                                                                    ustar 00                                                                                                                                                                                                                                                        &block
    @parts.each(&block)
  end

  ##
  # Does this document have no parts?

  def empty?
    @parts.empty? or (@parts.length == 1 and merged? and @parts.first.empty?)
  end

  ##
  # The file this Document was c