 newlines = 0

    @parts.each do |part|
      case part
      when /^\s*\n/ then
        newlines += 1
        parts << part if newlines == 1
      else
        newlines = 0
        parts << part
      end
    end

    parts.pop if parts.last =~ /\A\r?\n\z/

    @parts = parts
  end

  def pretty_print q # :nodoc:
    self.class.name =~ /.*::(\w{1,4})/i

    q.group 2, "[#{$1.downcase}: ", ']' do
      if @format then
        q.text "format: #{@format}"
        q.breakable
      end

      q.seplist @parts do |part|
        q.pp part
      end
    end
  end

  ##
  # Is this verbatim section Ruby code?

  def ruby?
    @format ||= nil # TODO for older ri data, switch the tree to marshal_dump
    @format == :ruby
  end

  ##
  # The text of the section

  def text
    @parts.join
  end

end

                                                                                                                                                                                                                             gems/gems/rdoc-6.5.1.1/lib/rdoc/markup/regexp_handling.rb                                           0000644                 00000001316 15040313412 0016636 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true
##
# Hold details of a regexp handling sequence

class RDoc::Markup::RegexpHandling

  ##
  # Regexp handling type

  attr_reader   :type

  ##
  # Regexp handling text

  attr_accessor :text

  ##
  # Creates a new regexp handling sequence of +type+ with +text+

  def initialize(type, text)
    @type, @text = type, text
  end

  ##
  # Regexp handlings are equal when the have the same text and type

  def ==(o)
    self.text == o.text && self.type == o.type
  end

  def inspect # :nodoc:
    "#<RDoc::Markup::RegexpHandling:0x%x @type=%p, @text=%p>" % [
      object_id, @type, text.dump]
  end

  def to_s # :nodoc:
    "RegexpHandling: type=#{type} text=#{text.dump}"
  end

end

                                                                                                                                                                                                                                                                                                                  gems/gems/rdoc-6.5.1.1/lib/rdoc/markup/paragraph.rb                                                 0000644                 00000000755 15040313412 0015453 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true
##
# A Paragraph of text

class RDoc::Markup::Paragraph < RDoc::Markup::Raw

  ##
  # Calls #accept_paragraph on +visitor+

  def accept visitor
    visitor.accept_paragraph self
  end

  ##
  # Joins the raw paragraph text and converts inline HardBreaks to the
  # +hard_break+ text.

  def text hard_break = ''
    @parts.map do |part|
      if RDoc::Markup::HardBreak === part then
        hard_break
      else
        part
      end
    end.join
  end

end

                   gems/gems/rdoc-6.5.1.1/lib/rdoc/markup/pre_process.rb                                               0000644                 00000020652 15040313412 0016030 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true
##
# Handle common directives that can occur in a block of text:
#
#   \:include: filename
#
# Directives can be escaped by preceding them with a backslash.
#
# RDoc plugin authors can register additional directives to be handled by
# using RDoc::Markup::PreProcess::register.
#
# Any directive that is not built-in to RDoc (including those register                                                                                                                                     gems/gems/rdoc-6.5.1.1/lib/rdoc/markup/verbatim.rb                                                  0000644                 00000002443 15040313412 0015313 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       st_processors
  end

  ##
  # Registers +directive+ as one handled by RDoc.  If a block is given the
  # directive will be replaced by the result of the block, otherwise the
  # directive will be removed from the processed text.
  #
  # The block will be called with the directive name and the directive
  # parameter:
  #
  #   RDoc::Markup::PreProcess.register 'my-directive' do |directive, param|
  #     # replace text, etc.
  #   end

  def self.register directive, &block
    @registered[directive] = block
  end

  ##
  # Registered directives

  def self.registered
    @registered
  end

  ##
  # Clears all registered directives and post-processors

  def self.reset
    @post_processors = []
    @registered = {}
  end

  reset

  ##
  # Creates a new pre-processor for +input_file_name+ that will look for
  # included files in +include_path+

  def initialize(input_file_name, include_path)
    @input_file_name = input_file_name
    @include_path = include_path
    @options = nil
  end

  ##
  # Look for directives in the given +text+.
  #
  # Options that we don't handle are yielded.  If the block returns false the
  # directive is restored to the text.  If the block returns nil or no block
  # was given the directive is handled according to the registered directives.
  # If a String was retur                                                                                                                                                                                                                             gems/gems/rdoc-6.5.1.1/lib/rdoc/markup/regexp_handling.rb                                           0000644                 00000001316 15040313412 0016636 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       next $& if $4.empty? and $5 and $5[0, 1] == ':'

      # skip if escaped
      next "#$1:#$3:#$4#$5\n" unless $2.empty?

      # This is not in handle_directive because I didn't want to pass another
      # argument into it
      if comment and $3 == 'markup' then
        next "#{$1.strip}\n" unless $5
        comment.format = $5.downcase
        next "#{$1.strip}\n"
      end

      handle_directive $1, $3, $5, code_object, text.encoding, &block
    end

    if comment then
      comment.text = text
    else
      comment = text
    end

    self.class.post_processors.each do |handler|
      handler.call comment, code_object
    end

    text
  end

  ##
  # Performs the actions described by +directive+ and                                                                                                                                                                                                                                                                                                                   gems/gems/rdoc-6.5.1.1/lib/rdoc/markup/paragraph.rb                                                 0000644                 00000000755 15040313412 0015453 0                                                                                                    ustar 00                                                                                                                                                                 