dled by
  # {the superclass}[rdoc-ref:RDoc::Markup::ToHtml#handle_regexp_RDOCLINK]

  def handle_regexp_RDOCLINK target
    url = target.text

    case url
    when /\Ardoc-ref:/ then
      cross_reference $'
    else
      super
    end
  end

  ##
  # Generates links for <tt>rdoc-ref:</tt> scheme URLs and allows
  # RDoc::Markup::ToHtml to handle other schemes.

  def gen_url url, text
    return super unless url =~ /\Ardoc-ref:/

    name = $'
    cross_reference name, text, name == text
  end

  ##
  # Creates an HTML link to +name+ with the given +text+.

  def link name, text, code = true
    if !(name.end_with?('+@', '-@')) and name =~ /(.*[^#:])@/
      name = $1
      label = $'
    end

    ref = @c