ng

  def init_tags
    add_tag :BOLD, '+b', '-b'
    add_tag :EM,   '+_', '-_'
    add_tag :TT,   ''  , ''   # we need in_tt information maintained
  end

  ##
  # Makes heading text bold.

  def accept_heading heading
    use_prefix or @res << ' ' * @indent
    @res << @headings[heading.level][0]
    @in_b = true
    @res << attributes(heading.text)
    @in_b = false
    @res << @headings[heading.level][1]
    @res << "\n"
  end

  ##
  # Turns on or off regexp handling for +convert_string+

  def annotate tag
    case tag
    when '+b' then @in_b = true
    when '-b' then @in_b = false
    when '+_' then @in_em = true
    when '-_' then @in_em = false
    end
    ''
  end

  ##
  # Calls convert_string on the result of convert_regexp_handling

  def convert_regexp_handling target
    convert_string super
  end

  ##
  # Adds bold or underline mixed with backspaces

  def convert_string string
    return string unless @in_b or @in_em
    chars = if @in_b then
              string