lists behave like HTML definition lists.  Each list item can
# describe multiple terms.  See RDoc::Markup::L                                                                                                                                                                                                                                                                                                                                                                                                                    gems/gems/rdoc-6.5.1.1/lib/rdoc/markup/heading.rb                                                   0000644                 00000002760 15040313411 0015102 0                                                                                                    ustar 00                                                                                                                                                                                                                                                        end

  ##
  # Returns the last item in the list

  def last
    @items.last
  end

  def pretty_print q # :nodoc:
    q.group 2, "[list: #{@type} ", ']' do
      q.seplist @items do |item|
        q.pp item
      end
    end
  end

  ##
  # Appends +items+ to the list

  def push *items
    @items.concat items
  end

end

                                                                                                                                                                                           gems/gems/rdoc-6.5.1.1/lib/rdoc/markup/to_joined_paragraph.rb                                       0000644                 00000002213 15040313411 0017473 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true
##
# Joins the parts of an RDoc::Markup::Paragraph into a single String.
#
# This allows for easier maintenance and testing of Markdown support.
#
# This formatter only works on Paragraph instances.  Attempting to process
# other markup syntax items will not work.

class RDoc::Markup::ToJoinedParagraph < RDoc::Markup::Formatter

  def initialize # :nodoc:
    super nil
  end

  def start_accepting # :nodoc:
  end

  def end_accepting # :nodoc:
  end

  ##
  # Co                gems/gems/rdoc-6.5.1.1/lib/rdoc/markup/attributes.rb                                                0000644                 00000002375 15040313411 0015673 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                   ignore
  alias accept_rule            ignore
  alias accept_verbatim        ignore
  alias accept_table           ignore

end

                                                                                                                                                                                                                                                                                                                                                                                     gems/gems/rdoc-6.5.1.1/lib/rdoc/markup/to_html.rb                                                   0000644                 00000023670 15040313411 0015154 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true
require 'cgi/util'

##
# Outputs RDoc markup as HTML.

class RDoc::Markup::ToHtml < RDoc::Markup::Formatter

  include RDoc::Text

  # :section: Utilities

  ##
  # Maps RDoc::Markup::Parser::LIST_TOKENS types to HTML tags
                                                                                                                                                                                                                                                                   gems/gems/rdoc-6.5.1.1/lib/rdoc/markup/list.rb                                                      0000644                 00000003505 15040313411 0014454 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       m_path

  # :section:

  ##
  # Creates a new formatter that will output HTML

  def initialize options, markup = nil
    super

    @code_object = nil
    @from_path = ''
    @in_list_entry = nil
    @list = nil
    @th = nil
    @hard_break = "<br>\n"

    init_regexp_handlings

    init_tags
  end

  # :section: Regexp Handling
  #
  # These methods are used by regexp handling markup added by RDoc::Markup#add_regexp_handling.

  URL_CHARACTERS_REGEXP_STR = /[A-Za-z0-9\-._~:\/\?#\[\]@!$&'\(\)*+,;%=]/.source

  ##
  # Adds regexp handlings.

  def init_regexp_handlings
    # external links
    @markup.add_regexp_handling(/(?:link:|https?:|mailto:|ftp:|irc:|www\.)#{URL_CHARACTERS_REGEXP_STR}+\w/,
                                :HYPERLINK)
    init_link_notation_regexp_handlings
  end

  ##
  # Adds regexp handlings about link notations.

  def init_link_notation_regexp_handlings
    add_regexp_handling_RDOCLINK
    add_regexp_handling_TIDYLINK
  end

  def handle_RDOCLINK url # :nodoc:
    case url
    when /^rdoc-ref:/
      CGI.escapeHTML($')
    when /^rdoc-label:/
      text = $'

      text = case text
             when /\Alabel-/    then $'
             when /\Afootmark-/ then $'
             when /\Afoottext-/ then $'
             else                    text
             end

      gen_url CGI.escapeHTML(url), CGI.escapeHTML(text)
    when /^rdoc-image:/
      %[<img src=\"#{CGI.escapeHTML($')}\">]
    when /\Ardoc-[a-z]+:/
      CGI.escapeHTML($')
    end
  end

  ##
  # +target+ is a <code><br></code>

  def handle_regexp_HARD_BREAK target
    '<br>'
  end

  ##
  # +target+ is a potential link.  The following schemes are handled:
  #
  # <tt>mailto:</tt>::
  #   Inserted as-is.
  # <tt>http:</tt>::
  #   Links are checked to see if they reference an image. If so, that image
  #   gets inserted using an <tt><img></tt>                                                                                                                                                                                            gems/gems/rdoc-6.5.1.1/lib/rdoc/markup/to_joined_paragraph.rb                                       0000644                 00000002213 15040313411 0017473 0                                                                                                    ustar 00                                                                                                                                                                                                                                                        where the label is different from the URL
  # <tt>label[url]</tt> or <tt>{long label}[url]</tt>

  def handle_regexp_TIDYLINK(target)
    text = target.text

    return text unless
      text =~ /^\{(.*)\}\[(.*?)\]$/ or text =~ /^(\S+)\[(.*?)\]$/

    label = $1
    url   = CGI.escapeHTML($2)

    if /^rdoc-image:/ =~ label
      label = handle_RDOCLINK(label)
    else
      label = CGI.escapeHTML(label)
    end

    gen_url url, label
  end

  # :section: Visitor
  #
  # These methods implement the HTML visitor.

  ##
  # Prepares the visitor for HTML generation

  def start_accepting
    @res = []
    @in_list_entry = []
    @list = []
  end

  ##
  # Returns the generated output

  def end_accepting
    @res.join
  end

  ##
  # Adds +block_quote+ to the output

  def accept_block_quote block_quote
    @res << "\n<blockquote>"

    block_quote.parts.each do |part|
      part.accept self
    end

    @res << "</blockquote>\n"
  end

  ##
  # Adds +paragraph+ to the output

  def accept_paragraph paragraph
    @res << "\n<p>"
    text = paragraph.text @hard_break
    text = text.gsub(/\r?\n/, ' ')
    @res << to_html(text)
    @res << "</p>\n"                                                                                                                                                                                                                                                                                                                                                                                     gems/gems/rdoc-6.5.1.1/lib/rdoc/markup/to_html.rb                                                   0000644                 00000023670 15040313411 0015154 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       
  # Prepares the visitor for consuming +list+

  def accept_list_start(list)
    @list << list.type
    @res << html_list_name(list.type, true)
    @in_list_entry.push false
  end

  ##
  # Finishes consumption of +list+

  def accept_list_end(list)
    @list.pop
    if tag = @in_list_entry.pop
      @res << tag
    end
    @res << html_list_name(list.type, false) << "\n"
  end

  ##
  # Prepares the visitor for consuming +list_item+

