gems/gems/rdoc-6.5.1.1/lib/rdoc/markup/block_quote.rb                                               0000644                 00000000374 15040313412 0016012 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true
##
# A quoted section which contains markup items.

class RDoc::Markup::BlockQuote < RDoc::Markup::Raw

  ##
  # Calls #accept_block_quote on +visitor+

  def accept visitor
    visitor.accept_block_quote self
  end

end

                                                                                                                                                                                                                                                                    gems/gems/rdoc-6.5.1.1/lib/rdoc/markup/to_table_of_contents.rb                                      0000644                 00000003335 15040313412 0017675 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true
##
# Extracts just the RDoc::Markup::Heading elements from a
# RDoc::Markup::Document to help build a table of contents

class RDoc::Markup::ToTableOfContents < RDoc::Markup::Formatter

  @to_toc = nil

  ##
  # Singleton for table-of-contents generation

  def self.to_toc
    @to_toc ||= new
  end

  ##
  # Output accumulator

  attr_reader :res

  ##
  # Omits headings with a level less than the given level.

  attr_accessor :omit_headings_below

  def initialize # :nodoc:
    super nil

    @omit_headings_below = nil
  end

  ##
  # Adds +document+ to the output, using its heading cutoff if present

  def accept_document document
    @omit_headings_below = document.omit_headings_below

    super
  end

  ##
  # Adds +heading+ to the table of contents

  def accept_heading heading
    @res << heading unless suppressed? heading
  end

  ##
  # Returns the table of contents

  def end_accepting
    @res
  end

  ##
  # Prepares the visitor for text generation

  def start_accepting
    @omit_headings_below = nil
    @res = []
  end

  ##
  # Returns true if +heading+ is below the display threshold

  def suppressed? heading
    return false unless @omit_headings_below

    heading.level > @omit_headings_below
  end

  # :stopdoc:
  alias accept_block_quote     ignore
  alias accept_raw             ignore
  alias accept_rule            ignore
  alias accept_blank_line      ignore
  alias accept_paragraph       ignore
  alias accept_verbatim        ignore
  alias accept_list_end        ignore
  alias accept_list_item_start ignore
  alias accept_list_item_end   ignore
  alias accept_list_end_bullet ignore
  alias accept_list_start      ignore
  alias accept_table           ignore
  # :startdoc:

end

                                                                                                                                                                                                                                                                                                   gems/gems/rdoc-6.5.1.1/lib/rdoc/markup/hard_break.rb                                                0000644                 00000000676 15040313412 0015572 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true
##
# Subclass of the RDoc::Markup::ToHtml class that supports looking up method
# names, classes, etc to create links.  RDoc::CrossReference is used to
# generate those links based on the current context.

class RDoc::Markup::ToHtmlCrossref < RDoc::Markup::ToHtml

  # :stopdoc:
  ALL_CROSSREF_REGEXP = RDoc::CrossReference::ALL_CROSSREF_REGEXP
  CLASS_REGEXP_STR    = RDoc::CrossReference::CLASS_REGEXP_STR
  CROSSR                                                                  gems/gems/rdoc-6.5.1.1/lib/rdoc/markup/blank_line.rb                                                0000644                 00000000607 15040313412 0015600 0                                                                                                    ustar 00                                                                                                                  