gems/gems/rdoc-6.5.1.1/lib/rdoc/markup/to_test.rb                                                   0000644                 00000002216 15040313411 0015160 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true
##
# This Markup outputter is used for testing purposes.

class RDoc::Markup::ToTest < RDoc::Markup::Formatter

  # :stopdoc:

  ##
  # :section: Visitor

  def start_accepting
    @res = []
    @list = []
  end

  def end_accepting
    @res
  end

  def accept_paragraph(paragraph)
    @res << convert_flow(@am.flow(paragraph.text))
  end

  def accept_raw raw
    @res << raw.parts.join
  end

  def accept_verbatim(verbatim)
    @res << verbatim.text.gsub(/^(\S)/, '  \1')
  end

  def accept_list_start(list)
    @list << case list.type
             when :BULLET then
               '*'
             when :NUMBER then
               '1'
             else
               list.type
             end
  end

  def accept_list_end(list)
    @list.pop
  end

  def accept_list_item_start(list_item)
    @res << "#{' ' * (@list.size - 1)}#{@list.last}: "
  end

  def accept_list_item_end(list_item)
  end

  def accept_blank_line(blank_line)
    @res << "\n"
  end

  def accept_heading(heading)
    @res << "#{'=' * heading.level} #{heading.text}"
  end

  def accept_rule(rule)
    @res << '-' * rule.weight
  end

  # :startdoc:

end

                                                                                                                                                                                                                                                                                                                                                                                  gems/gems/rdoc-6.5.1.1/lib/rdoc/markup/table.rb                                                     0000644                 00000001744 15040313412 0014574 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true
##
# A section of table

class RDoc::Markup::Table
  attr_accessor :header, :align, :body

  def initialize header, align, body
    @header, @align, @body = header, align, body
  end

  def == other
    self.class == other.class and
      @header == other.header and
      @align == other.align and
      @body == other.body
  end

  def accept visitor
    visitor.accept_table @header, @body, @align
  end

                                                                          gems/gems/rdoc-6.5.1.1/lib/rdoc/markup/to_bs.rb                                                     0000644                 00000003223 15040313411 0014604 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       gems/gems/rdoc-6.5.1.1/lib/rdoc/markup/to_html_snippet.rb                                           0000644                 00000012731 15040313412 0016713 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true
##
# Outputs RDoc markup as paragraphs with inline markup only.

class RDoc::Markup::ToHtmlSnippet < RDoc::Markup::ToHtml

  ##
  # After this many characters the input will be cut off.

  attr_reader :character_limit

  ##
  # The number of characters seen so far.

  attr_reader :characters # :nodoc:

  ##
  # The attribute bitmask

  attr_reader :mask

  ##
  # After this many paragraphs the input will be cut off.

  attr_reader :paragraph_limit

  ##
  # Count of paragraphs found

  attr_reader :paragraphs

  ##
  # Creates a new ToHtmlSnippet formatter that will cut off the input on the
  # next word boundary after the given number of +characters+ or +paragraphs+
  # of text have been encountered.

  def initialize options, characters = 100, paragraphs = 3, markup = nil
    super options, markup

    @character_limit = characters
    @paragraph_limit = paragraphs

    @characters = 0
    @mask       = 0
    @paragraphs = 0

    @markup.add_regexp_handling RDoc::CrossReference::CROSSREF_REGEXP, :CROSSREF
  end

  ##
  # Adds +heading+ to the output as a paragraph

  def accept_heading heading
    @res << "<p>#{to_html he                                                                                                                                                                                                                                                                                                                                      