gems/gems/rdoc-6.5.1.1/lib/rdoc/markup/table.rb                                                     0000644                 00000001744 15040313412 0014574 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       rts flow items +flow+

  def convert_flow flow
    throw :done if @characters >= @character_limit

    res = []
    @mask = 0

    flow.each do |item|
      case item
      when RDoc::Markup::AttrChanger then
        off_tags res, item
        on_tags  res, item
      when String then
        text = convert_string item
        res << truncate(text)
      when RDoc::Markup::RegexpHandling then
        text = convert_regexp_handling item
        res << truncate(text)
      else
        raise "Unknown flow element: #{item.inspect}"
      end

      if @characters >= @character_limit then
        off_tags res, RDoc::Markup::AttrChanger.new(0, @mask)
        break
      end
    end

    res << ' ...' if @characters >= @character_limit

    res.join
  end

  ##
  # Maintains a bitmask to allow HTML elements to be closed properly.  See
  # RDoc::Markup::Formatter.

  def on_tags res, item
    @mask ^= item.turn_on

    super
  end

  ##
  # Maintains a bitmask to allow HTML elements to be                            gems/gems/rdoc-6.5.1.1/lib/rdoc/markup/to_html_snippet.rb                                           0000644                 00000012731 15040313412 0016713 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       gems/gems/rdoc-6.5.1.1/lib/rdoc/markup/indented_paragraph.rb                                        0000644                 00000001612 15040313412 0017316 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true
##
# An Indented Paragraph of text

class RDoc::Markup::IndentedParagraph < RDoc::Markup::Raw

  ##
  # The indent in number of spaces

  attr_reader :indent

  ##
  # Creates a new IndentedParagraph containing +parts+ indented with +indent+
  # spaces

  def initialize indent, *parts
    @indent = indent

    super(*parts)
  end

  def == other # :nodoc:
    super and indent == other.indent
  end

  ##
  # Calls #accept_indented_paragraph on +visitor+

  def accept visitor
    visitor.accept_indented_paragraph self
  end

  ##
  # Joins the raw paragraph text and converts inline HardBreaks to the
  # +hard_break+ text followed by the indent.

  def text hard_break = nil
    @parts.map do |part|
      if RDoc::Markup::HardBreak === part then
        '%1$s%3$*2$s' % [hard_break, @indent, ' '] if hard_break
      else
        part
      end
    end.join
  end

end

                                                                                                                      gems/gems/rdoc-6.5.1.1/lib/rdoc/markup/to_markdown.rb                                               0000644 