d>[<url>]

  def add_regexp_handling_TIDYLINK
    @markup.add_regexp_handling(/(?:
                                  \{.*?\} |    # multi-word label
                                  \b[^\s{}]+? # single-word label
                                 )

                                 \[\S+?\]     # link target
                                /x, :TIDYLINK)
  end

  ##
  # Add a new set of tags for an attribute. We allow separate start and end
  # tags for flexibility

  def add_tag(name, start, stop)
    attr = @attributes.bitmap_for name
    @attr_tags << InlineTag.new(attr, start, stop)
  end

  ##
  # Allows +tag+ to be decorated with additional information.

  def annotate(tag)
    tag
  end

  ##
  # Marks up +conten                                                                                                                                                                                                                                                                                                      gems/gems/rdoc-6.5.1.1/lib/rdoc/markup/rule.rb                                                      0000644                 00000000473 15040313412 0014452 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       f respond_to? method_name then
        target.text = public_send method_name, target
        handled = true
      end
    end

    unless handled then
      target_name = @attributes.as_string target.type

      raise RDoc::Error, "Unhandled regexp handling #{target_name}: #{target}"
    end

    target.text
  end                                                                                                                                                                                                     gems/gems/rdoc-6.5.1.1/lib/rdoc/markup/attr_changer.rb                                              0000644                 00000000650 15040313412 0016141 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       ags res, item
    attr_mask = item.turn_off
    return if attr_mask.zero?

    @attr_tags.reverse_each do |tag|
      if attr_mask & tag.bit != 0 then
        @in_tt -= 1 if tt? tag
        res << annotate(tag.off)
      end
    end
  end

  ##
  # Extracts and a scheme, url and an anchor id from +url+ and returns them.

  def parse_url url
    case url
    when /^rdoc-label:([^:]*)(?::(.*))?/ then
      scheme = 'link'
                                                                                        gems/gems/rdoc-6.5.1.1/lib/rdoc/markup/formatter.rb                                                 0000644                 00000012720 15040313412 0015504 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       gems/gems/rdoc-6.5.1.1/lib/rdoc/markup/to_rdoc.rb                                                   0000644                 00000015033 15040313412 0015132 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true
##
# Outputs RDoc markup as RDoc markup! (mostly)

class RDoc::Markup::ToRdoc < RDoc::Markup::Formatter

  ##
  # Current indent amount for output in characters

  attr_accessor :indent

  ##
  # Output width in characters

  attr_accessor :width

  ##
  # Stack of current list indexes for alphabetic and numeric lists

  attr_reader :list_index

  ##
  # Stack of list types

  attr_reader :list_type

  ##
  # Stack of list widths for indentation

  attr_reader :list_width

  ##
  # Prefix for the next list item.  See #use_prefix

  attr_reader :prefix

  ##
  # Output accumulator

  attr_reader :res

  ##
  # Creates a new formatter that will output (mostly) \RDoc markup

  def initialize markup = nil
    super nil, markup

    @markup.add_regexp_handling(/\\\S/, :SUPPRESSED_CROSSREF)
    @width = 78
    init_tags

    @headings = {}
    @headings.default = []

    @headings[1] = ['= ',      '']
    @headings[2] = ['== ',     '']
    @headings[3] = ['=== ',    '']
    @headings[4] = ['==== ',   '']
    @headings[5] = ['===== ',  '']
    @headings[6] = ['====== ', '']

    @hard_break = "\n"
  end

  ##
  # Maps attributes to HTML sequences

  def init_tags
    add_tag :BOLD, "<b>", "</b>"
    add_tag :TT,   "<tt>", "</tt>"
    add_tag :EM,   "<em>", "</em>"
  end

  ##
  # Adds +blank_line+ to the output

  def accept_blank_line blank_line
    @res << "\n"
  end

  ##
  # Adds +paragraph+ to the output

  def accept_block_quote block_quote
    @indent += 2

    block_quote.parts.each do |part|
      @prefix = '> '

      part.accept self
    end

    @indent -= 2
  end

  ##
  # Adds +heading+ to the output

  def accept_heading heading
    use_prefix or @res << ' ' * @indent
    @res << @headings[heading.level][0]
    @res << attributes(heading.text)
    @res << @headings[heading.level][1]
    @res << "\n"
  end

  ##
  # Finishes consumption of +list+

  def accept_list_end list
    @list_index.pop
    @list_type.pop
    @list_width.pop
  end

  ##
  # Finishes consumption of +list_item+

  def accept_list_item_end list_item
    width = case @list_type.last
            when :BULLET then
              2
            when :NOTE, :LABEL then
              if @prefix then
                @res << @prefix.strip
                @prefix = nil
              end

              @res << "\n"
              2
            else
              bullet = @list_index.last.to_s
              @list_index[-1] = @list_index.last.succ
              bullet.length + 2
            end

    @indent -= width
  end

  ##
  # Prepares the visi