um_width, @num_params, undoc_width, @undoc_params] if
        @coverage_level > 0

    report << "\n"

    report << "Total:      %*d (%*d undocumented)\n" % [
      num_width, @num_items, undoc_width, @undoc_items]

    report << "%6.2f%% documented\n" % percent_doc
    report << "\n"
    report << "Elapsed: %0.1fs\n" % (Time.now - @start)

    RDoc::Markup::Document.new report
  end

  ##
  # Determines which parameters in +method+ were not documented.  Returns a
  # total parameter count and an Array of undocumented methods.

  def undoc_params method
    @formatter ||= RDoc::Markup::ToTtOnly.new

    params = method.param_list

    params = params.map { |param| param.gsub(/^\*\*?/, '') }

    return 0, [] if params.empty?

    document = parse method.comment

    tts = document.accept @formatter

    undoc = params - tts

    [params.length, undoc]
  end

  autoload :Quiet,   "#{__dir__}/stats/quiet"
  autoload :Normal,  "#{__dir__}/stats/normal"
  autoload :Verbose, "#{__dir__}/stats/verbose"

end
      gems/gems/rdoc-6.5.1.1/lib/rdoc/i18n.rb                                                             0000644                 00000000264 15040313412 0012761 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true
##
# This module provides i18n related features.

module RDoc::I18n

  autoload :Locale, "#{__dir__}/i18n/locale"
  require_relative 'i18n/text'

end
                                                                                                                                                                                                                                                                                                                                            gems/gems/rdoc-6.5.1.1/lib/rdoc/require.rb                                                          0000644                 00000001705 15040313412 0013657 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true
##
# A file loaded by \#require

class RDoc::Require < RDoc::CodeObject

  ##
  # Name of the required file

  attr_accessor :name

  ##
  # Creates a new Require that loads +name+ with +comment+

  def initialize(name, comment)