+ 1, tm.tm_mday,
                tm.tm_hour, tm.tm_min, tm.tm_sec, (int)tv.tv_usec);
        }
        else if (flag & LSAPI_LOG_TIMESTAMP_HMS)
        {
            p += snprintf(p, 1024, "%02d:%02d:%02d ",
                tm.tm_hour, tm.tm_min, tm.tm_sec);
        }
    }

    int level = flag & LSAPI_LOG_LEVEL_BITS;
    if (level && level <= LSAPI_LOG_FLAG_FATAL)
    {
        p += snprintf(p, 100, "[%s] ", s_log_level_names[level]);
    }

    if (flag & LSAPI_LOG_PID)
    {
        p += snprintf(p, 100, "[UID:%d][%d] ", getuid(), s_pid);
    }

    if (p > buf)
        fprintf(stderr, "%.*s", (int)(p - buf), buf);
    va_list ap;
    va_start(ap, fmt);
    vfprintf(stderr, fmt, ap);
    va_end(ap);
}

#ifdef LSAPI_DEBUG

#define DBGLOG_FLAG (LSAPI_LOG_TIMESTAMP_FULL|LSAPI_LOG_FLAG_DEBUG|LSAPI_LOG_PID)
#define lsapi_dbg(...)   LSAPI_Log(DBGLOG_FLAG, __VA_ARGS__)

#else

#define lsapi_dbg(...)

#endif

#define lsapi_log(...)  LSAPI_Log(LSAPI_LOG_TIMESTAMP_FULL|LSAPI_LOG_PID, __VA_ARGS__)


void lsapi_perror(const char * pMessage, int err_no)
{
    lsapi_log("%s, errno: %d (%s)\n", pMessage, err_no, strerror(err_no));
}


static int lsapi_parent_dead()
{
    // Return non-zero if the parent is dead.  0 if still alive.
    if (!s_ppid) {
        // not checking, so not dead
        return(0);
    }
    if (s_restored_ppid) {
        if (kill(s_restored_ppid,0) == -1) {
            if (errno == EPERM) {
                return(0); // no permission, but it's still there.
            }
            return(1); // Dead
        }
        return(0); // it worked, so it's not dead
    }
    return(s_ppid != getppid());
}


static void lsapi_sigpipe( int sig )
{
}


static void lsapi_siguser1( int sig )
{
    g_running = 0;
}

#ifndef sighandler_t
typedef void (*sighandler_t)(int);
#endif

static void lsapi_signal(int signo, sighandler_t handler)
{
    struct sigaction sa;

    sigaction(signo, NULL, &sa);

    if (sa.sa_handler == SIG_DFL)
    {
        sigemptyset(&sa.sa_mask);
        sa.sa_flags = 0;
        sa.sa_handler = handler;
        sigaction(signo, &sa, NULL);
    }
}


static int s_enable_core_dump = 0;
static void lsapi_enable_core_dump(void)
{
#if defined(__FreeBSD__ ) || defined(__NetBSD__) || defined(__OpenBSD__) \
    || defined(macintosh) || defined(__APPLE__) || defined(__APPLE_CC__)
    int  mib[2];
    size_t len;

#if !defined(__OpenBSD__)
    len = 2;
    if ( sysctlnametomib("kern.sugid_coredump", mib, &len) == 0 )
    {
        len = sizeof(s_enable_core_dump);
        if (sysctl(mib, 2, NULL, 0, &s_enable_core_dump, len) == -1)
            perror( "sysctl: Failed to set 'kern.sugid_coredump', "
                    "core dump may not be available!");
    }
#else
    int set = 3;
    len = sizeof(set);
    mib[0] = CTL_KERN;
    mib[1] = KERN_NOSUIDCOREDUMP;
    if (sysctl(mib, 2, NULL, 0, &set, len) == 0) {
        s_enable_core_dump = 1;
    }
#endif


#endif

#if defined(linux) || defined(__linux) || defined(__linux__) || defined(__gnu_linux__)
    if (prctl(PR_SET_DUMPABLE, s_enable_core_dump,0,0,0) == -1)
        perror( "prctl: Failed to set dumpable, "
                    "core dump may not be available!");
#endif
}


static inline void lsapi_buildPacketHeader( struct lsapi_packet_header * pHeader,
                                char type, int len )
{
    pHeader->m_versionB0 = LSAPI_VERSION_B0;  /* LSAPI protocol version */
    pHeader->m_versionB1 = LSAPI_VERSION_B1;
    pHeader->m_type      = type;
    pHeader->m_flag      = LSAPI_ENDIAN;
    pHeader->m_packetLen.m_iLen = len;
}


static  int lsapi_set_nblock( int fd, int nonblock )
{
    int val = fcntl( fd, F_GETFL, 0 );
    if ( nonblock )
    {
        if (!( val & O_NONBLOCK ))
        {
            return fcntl( fd, F_SETFL, val | O_NONBLOCK );
        }
    }
    else
    {
        if ( val & O_NONBLOCK )
        {
            return fcntl( fd, F_SETFL, val &(~O_NONBLOCK) );
        }
    }
    return 0;
}


static int lsapi_close( int fd )
{
    int ret;
    while( 1 )
    {
        ret = close( fd );
        if (( ret == -1 )&&( errno == EINTR )&&(g_running))
            continue;
        return ret;
    }
}


static void lsapi_close_connection(LSAPI_Request *pReq)
{
    if (pReq->m_fd == -1)
        return;
    lsapi_close(pReq->m_fd);
    pReq->m_fd = -1;
    if (s_busy_workers)
        __atomic_fetch_sub(s_busy_workers, 1, __ATOMIC_SEQ_CST);
    if (s_worker_status)
        __atomic_store_n(&s_worker_status->m_state, LSAPI_STATE_IDLE,
                         __ATOMIC_SEQ_CST);
}


static inline ssize_t lsapi_read( int fd, void * pBuf, size_t len )
{
    ssize_t ret;
    while( 1 )
    {
        ret = read( fd, (char *)pBuf, len );
        if (( ret == -1 )&&( errno == EINTR )&&(g_running))
            continue;
        return ret;
    }
}


/*
static int lsapi_write( int fd, const void * pBuf, int len )
{
   int ret;
   const char * pCur;
   const char * pEnd;
   if ( len == 0 )
       return 0;
   pCur = (const char *)pBuf;
   pEnd = pCur + len;
   while( g_running && (pCur < pEnd) )
   {
       ret = write( fd, pCur, pEnd - pCur );
       if ( ret >= 0)
           pCur += ret;
       else if (( ret == -1 )&&( errno != EINTR ))
           return ret;
   }
   return pCur - (const char *)pBuf;
}
*/


static int lsapi_writev( int fd, struct iovec ** pVec, int count, int totalLen )
{
    int ret;
    int left = totalLen;
    int n = count;

    if (s_skip_write)
        return totalLen;

    while(( left > 0 )&&g_running )
    {
        ret = writev( fd, *pVec, n );
        if ( ret > 0 )
        {
            left -= ret;
            if (( left <= 0)||( !g_running ))
                return totalLen - left;
            while( ret > 0 )
            {
                if ( (*pVec)->iov_len <= (unsigned int )ret )
                {
                    ret -= (*pVec)->iov_len;
                    ++(*pVec);
                }
                else
                {
                    (*pVec)->iov_base = (char *)(*pVec)->iov_base + ret;
                    (*pVec)->iov_len -= ret;
                    break;
                }
            }
        }
        else if ( ret == -1 )
        {
            if ( errno == EAGAIN )
            {
                if ( totalLen - left > 0 )
                    return totalLen - left;
                else
                    return -1;
            }
            else if ( errno != EINTR )
                return ret;
        }
    }
    return totalLen - left;
}


/*
static int getTotalLen( struct iovec * pVec, int count )
{
   struct iovec * pEnd = pVec + count;
   int total = 0;
   while( pVec < pEnd )
   {
       total += pVec->iov_len;
       ++pVec;
   }
   return total;
}
*/


static inline int allocateBuf( LSAPI_Request * pReq, int size )
{
    char * pBuf = (char *)realloc( pReq->m_pReqBuf, size );
    if ( pBuf )
    {
        pReq->m_pReqBuf = pBuf;
        pReq->m_reqBufSize = size;
        pReq->m_pHeader = (struct lsapi_req_header *)pReq->m_pReqBuf;
        return 0;
    }
    return -1;
}


static int allocateIovec( LSAPI_Request * pReq, int n )
{
    struct iovec * p = (struct iovec *)realloc(
                pReq->m_pIovec, sizeof(struct iovec) * n );
    if ( !p )
        return -1;
    pReq->m_pIovecToWrite = p + ( pReq->m_pIovecToWrite - pReq->m_pIovec );
    pReq->m_pIovecCur = p + ( pReq->m_pIovecCur - pReq->m_pIovec );
    pReq->m_pIovec = p;
    pReq->m_pIovecEnd = p + n;
    return 0;
}


static int allocateRespHeaderBuf( LSAPI_Request * pReq, int size )
{
    char * p = (char *)realloc( pReq->m_pRespHeaderBuf, size );
    if ( !