y. Tasks and dependencies are
specified in standard Ruby syntax.

Rake has the following features:

* Rakefiles (rake's version of Makefiles) are completely defined in
  standard Ruby syntax.  No XML files to edit.  No quirky Makefile
  syntax to worry about (is that a tab or a space?)

* Users can specify tasks with prerequisites.

* Rake supports rule patterns to synthesize implicit tasks.

* Flexible FileLists that act like arrays but know about manipulating
  file names and paths.

* A library of prepackaged tasks to make building rakefiles easier. For example,
  tasks for building tarballs. (Formerly
  tasks for building RDoc, Gems, and publishing to FTP were included in rake but they're now
  available in RDoc, RubyGems, and rake-contrib respectively.)

* Supports parallel execution of tasks.

== Installation

=== Gem Installation

Download and install rake with the following.

  gem install rake

== Usage

=== Simple Example

First, you must write a "Rakefile" file which contains the build rules. Here's
a simple example:

  task default: %w[test]

  task :test do
    ruby "test/unittest.rb"
  end

This Rakefile has two tasks:

* A task named "test", which -- upon invocation -- will run a unit test file
  in Ruby.
* A task named "default". This task does nothing by itself, but it has exactly
  one dependency, namely the "test" task. Invoking the "default" task will
  cause Rake to invoke the "test" task as well.

Running the "rake" command without any options will cause it to run the
"default" task in the Rakefile:

  % ls
  Rakefile     test/
  % rake
  (in /home/some_user/Projects/rake)
  ruby test/unittest.rb
  ....unit test output here...

Type "rake --help" for all available options.

== Resources

=== Rake Information

* {Rake command-line}[link:doc/command_line_usage.rdoc]
* {Writing Rakefiles}[link:doc/rakefile.rdoc]
* The original {Rake announcement}[link:doc/rational.rdoc]
* Rake {glossary}[link:doc/glossary.rdoc]

=== Presentations and Articles about Rake

* Avdi Grimm's rake series:
  1. {Rake Basics}[https://avdi.codes/rake-part-1-basics/]
  2. {Rake File Lists}[https://avdi.codes/rake                                                                                                                                                                                                                                                                                                                                                                                                                                   gems/gems/rdoc-6.5.1.1/lib/rdoc/erb_partial.rb                                                      0000644                 00000000621 15040313414 0014465 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                               ustar 00                                                                                                                                                                                                                                                       i Nakada <nobu@ruby-lang.org></b>] For the initial patch for rule support.

[<b>Tilman Sau                                                                                                               gems/gems/rdoc-6.5.1.1/lib/rdoc/attr.rb                                                             0000644                 00000007411 15040313414 0013157 0                                                                                                    ustar 00                                                                                                                                                                                                                                                        limitation, the implied warranties of
merchantability and fitness for a particular purpose.

== Historical

Rake was originally created by Jim Weirich, who unfortunately passed away in
February 2014. This repository was originally hosted at
{github.com/jimweirich/rake}[https://github.com/jimweirich/rake/], however
with his passing, has                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     gems/gems/rake-13.0.6/lib/rake.rb                                                                   0000644                 00000004162 15040313415 0012113 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       Copyright (c) Jim Weirich

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     gems/gems/rake-13.0.6/lib/rake.rb                                                                   0000644                 00000004162 15040313415 0012113 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true
#--
# Copyright 2003-2010 by Jim Weirich (jim.weirich@gmail.com)
#
# Permission is h                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       gems/gems/rdoc-6.5.1.1/lib/rdoc/parser/rd.rb                                                        0000644                 00000000666 15040313414 0014113 0                                                                                                    ustar 00                                                                                                                                                                                                                                                        "fileutils"
require "singleton"
require "monitor"
require "optparse"
require "ostruct"

require "rake/ext/string"

require "rake/win32"

require "rake/linked_list"
require "rake/cpu_counter"
require "rake/scope"
require "rake/task_argument_error"
require "rake/rule_recursion_overflow_error"
require "rake/rake_module"
require "rake/trace_output"
require "rake/pseudo_status"
require "rake/task_arguments"
require "rake/invocation_chain"                                                                          gems/gems/rdoc-6.5.1.1/lib/rdoc/parser/c.rb                                                         0000644                 00000105715 15040313414 0013731 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              gems/gems/rake-13.0.6/lib/rake/promise.rb                                                           0000644                 00000004437 15040313415 0013576 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true
module Rake

  # A Promise object represents a promise to do work (a chore) in the
  # future. The promise is created with a block and a list of
  # arguments for the block. Calling value will return the value of
  # the promised chore.
  #
  # Used by Thre                                                                                                                                                                                                                                 gems/gems/rake-13.0.6/lib/rake/version.rb                                                           0000644                 00000000320 15040313415 0013570 0                                                                                                    ustar 00                                                                                                                                                                                                                                                           end
      error? ? raise(@error) : @result
    end

    # If no one else is working this promise, go ahead and do the chore.
    def work
      stat :attempting_lock_on, item_id: object_id
      if @mutex                                                                                                                                                                                                                                                                                                                gems/gems/rake-13.0.6/lib/rake/private_reader.rb                                                    0000644                 00000000612 15040313415 0015103 0                                                                                                    ustar 00                                                                                                                                                                                                                                                          def complete?
      result? || error?
    end

    # free up these items for the GC
    def discard
      @args = nil
      @block = nil
    end

    # Record execution statistics if there is a recorder
    def stat(*args)
      @recorder.call(*args) if @recorder
    end

  end

end
                                                                                                                                                                                                                                 gems/gems/rake-13.0.6/lib/rake/invocation_exception_mixin.rb                                        0000644                 00000000715 15040313415 0017546 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true
module Rake
  VERSION = "13.0.6"

  module Version # :nodoc: all
    MAJOR, MINOR, BUILD, *OTHER = Rake::VERSION.split "."

    NUMBERS = [MAJOR, MINOR, BUILD, *OTHER]
  end
end
                                                                                                                                                                                                                                                                                                                gems/gems/rake-13.0.6/lib/rake/dsl_definition.rb                                                    0000644                 00000012755 15040313415 0015114 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true
module Rake

  # Include PrivateReader to use +private_reader+.
  module PrivateReader           # :nodoc: all

    def self.included(base)
      base.extend(ClassMethods)
    end

    module ClassMethods

      # Declare a list of private accessors
      def private_reader(*names)
        attr_reader(*names)
        private(*names)
      end
    end

  end
end
                                                                                                                      gems/gems/rake-13.0.6/lib/rake/invocation_exception_mixin.rb                                        0000644                 00000000715 15040313415 0017546 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true
module Rake
  module InvocationExceptionMixin
    # Return the invocation chain (list of Rake tasks) that were in
    # effect when this exception was detected by rake.  May be null if
    # no tasks were active.
    def chain
      @rake_invocation_chain ||= nil
    end

    # Set the invocation chain in effect when this exception was
    # detected.
    def chain=(value)
      @rake_invocation_chain = value
    end
  end
end
                                                   gems/gems/rake-13.0.6/lib/rake/dsl_definition.rb                                                    0000644                 00000012755 15040313415 0015114 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true
# Rake DSL functions.
require "rake/file_utils_ext"

module Rake

  ##
  # DSL is a module that provides #task, #desc, #namespace, etc.  Use this
  # when you'd like to use rake outside the top level scope.
  #
  # For a Rakefile you run from the command line this module is automatically
  # included.

  module DSL

    #--
    # Include the FileUtils file manipulation functions in the top
    # level module, but mark them private so that they don't
    # unintentionally define methods on other objects.
    #++

    include FileUtilsExt
    private(*FileUtils.instance_methods(false))
    private(*FileUtilsExt.instance_methods(false))

    private

    # :call-seq:
    #   task(task_name)
    #   task(task_name: dependencies)
    #   task(task_name, arguments => dependencies)
    #
    # Declare a basic task.  The +task_name+ is always the first argument.  If
    # the task name contains a ":" it is defined in that namespace.
    #
    # The +dependencies+ may be a single task name or an Array of task names.
    # The +argument+ (a single name) or +arguments+ (an Array of names) define
    # the arguments provided to the task.
    #
    # The task, argument and dependency names may be either symbols or
    # strings.
    #
    # A task with a single dependency:
    #
    #   task clobber: %w[clean] do
    #     rm_rf "html"
    #   end
    #
    # A task with an argument and a dependency:
    #
    #   task :package, [:version] => :test do |t, args|
    #     # ...
    #   end
    #
    # To invoke this task from the command line:
    #
    #   $ rake package[1.2.3]
    #
    def task(*args, &block) # :doc:
      Rake::Task.define_task(*args, &block)
    end

    # Declare a file task.
    #
    # Example:
    #   file "config.cfg" => ["config.template"] do
    #     open("config.cfg", "w") do |outfile|
    #       open("config.template") do |infile|
    #         while line = infile.gets
    #           outfile.puts line
    #         end
    #       end
    #     end
    #  end
    #
    def file(*args, &block) # :doc:
      Rake::FileTask.define_task(*args, &block)
    end

    # Declare a file creation task.
    # (Mainly used for the directory command).
    def file_create(*args, &block)
      Rake::FileCreationTask.define_task(*args, &block)
    end

    # Declare a set of files tasks to create the given directories on
    # demand.
    #
    # Example:
    #   directory "testdata/doc"
    #
    def directory(*args, &block) # :doc:
      result = file_create(*args, &block)
      dir, _ = *Rake.application.resolve_args(args)
      dir = Rake.from_pathname(dir)
      Rake.each_dir_parent(dir) do |d|
        file_create d do |t|
          mkdir_p t.name unless File.exist?(t.name)
        end
      end
      result
    end

    # Declare a task that performs its prerequisites in
    # parallel. Multitasks does *not* guarantee that its prerequisites
    # will execute in any given order (which is obvious when you think
    # about it)
    #
    # Example:
    #   multitask deploy: %w[deploy_gem deploy_rdoc]
    #
    def multitask(*args, &block) # :doc:
      Rake::MultiTask.define_task(*args, &block)
    end

    # Create a new rake namespace and use it for evaluating the given
    # block.  Returns a NameSpace object that can be used to lookup
    # tasks defined in the namespace.
    #
    # Example:
    #
    #   ns = namespace "nested" do
    #     # the "nested:run" task
    #     task :run
    #   end
    #   task_run = ns[:run] # find :run in the given namespace.                   gems/gems/rake-13.0.6/lib/rake/rake_module.rb                                                       0000644                 00000002770 15040313415 0014405 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       auto-tasks.
    #
    # Example:
    #  rule '.o' => '.c' do |t|
    #    sh 'cc', '-o', t.name, t.source
    #  end
    #
    def rule(*args, &block) # :doc:
      Rake::Task.create_rule(*args, &block)
    end

    # Describes the next rake task.  Duplicate descriptions are discarded.
    # Descriptions are shown with <code>rake -T</code> (up to the first
    # sentence) and <code>rake -D</code> (the entire description).
    #
    # Example:
    #   desc "Run the Unit Tests"
    #   task test: [:build]
    #     # ... run tests
    #   end
    #
    def desc(description) # :doc:
      Rake.application.last_description = description
    end

    # Import the partial Rakefiles +fn+.  Imported files are loaded
    # _after_ the current file is completely loaded.  This allows the
    # import statement to appear anywhere in the importing file, and yet
    # allowing the imported files to depend on objects defined in the
    # importing file.
    #
    # A common use of the import statement is to include files
    # containing dependency declarations.
    #
    # See also the --rakelibdir command line option.
    #
    # Example:
    #   import ".depend", "my_rules"
    #
    def import(*fns) # :doc:
      fns.each do |fn|
        Rake.application.add_import(fn)
      end
    end
  end
  extend FileUtilsExt
end

# Extend the main object with the DSL commands. This allows top-level
# calls to task, etc. to work from a Rakefile without polluting the
# object inheritance tree.
self.extend Rake::DSL
                   gems/gems/rake-13.0.6/lib/rake/tasklib.rb                                                           0000644                 00000000245 15040313415 0013542 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true
require "rake/application"

module Rake

  class << self
    # Current Rake Application
    def application
      @application ||= Rake                                                                                                                                                                                                                                                                                                                                                           gems/gems/rake-13.0.6/lib/rake/packagetask.rb                                                       0000644                 00000014021 15040313415 0014364 0                                                                                                    ustar 00                                                                                                                                                                                                                                                        rake in a sub-shell.
    #
    # Example:
    #
    #   Dir.chdir 'other/directory'
    #
    #   other_rake = Rake.with_application do |rake|
    #     rake.load_rakefile
    #   end
    #
    #   puts other_rake.tasks

    def with_application(block_application = Rake::Application.new)
      orig_application = Rake.application

      Rake.application = block_application

      yield block_application

      block_application
    ensure
      Rake.application = orig_application
    end
  end

end
        gems/gems/rake-13.0.6/lib/rake/tasklib.rb                                                           0000644                 00000000245 15040313415 0013542 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true
require "rake"

module Rake

  # Base class for Task Libraries.
  class TaskLib
    include Cloneable
    include Rake::DSL
  end

end
                                                                                                                                                                                                                                                                                                                                                           gems/gems/rake-13.0.6/lib/rake/packagetask.rb                                                       0000644                 00000014021 15040313415 0014364 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true
# Define a package task library to aid in the definition of
# redistributable package files.

require "rake"
require "rake/tasklib"

module Rake

  # Create a packaging task that will package the project into
  # distributable files (e.g zip archive or tar files).
  #
  # The PackageTask will create the following targets:
  #
  # +:package+ ::
  #   Create all the requested package files.
  #
  # +:clobber_package+ ::
  #   Delete all the package files.  This target is automatically
  #   added to the main clobber target.
  #
  # +:repackage+ ::
  #   Rebuild the package files from scratch, even if they are not out
  #   of date.
  #
  # <tt>"<em>package_dir</em>/<em>name</em>-<em>version</em>.tgz"</tt> ::
  #   Create a gzipped tar package (if <em>need_tar</em> is true).
  #
  # <tt>"<em>package_dir</em>/<em>name</em>-<em>version</em>.tar.gz"</tt> ::
  #   Create a gzipped tar package (if <em>need_tar_gz</em> is true).
  #
  # <tt>"<em>package_dir</em>/<em>name</em>-<em>version</em>.tar.bz2"</tt> ::
  #   Create a bzip2'd tar package (if <em>need_tar_bz2</em> is true).
  #
  # <tt>"<em>package_dir</em>/<em>name</em>-<em>version</em>.zip"</tt> ::
  #   Create a zip package archive (if <em>need_zip</em> is true).
  #
  # Example:
  #
  #   Rake::PackageTask.new("rake", "1.2.3") do |p|
  #     p.need_tar = true
  #     p.package_files.include("lib/**/*.rb")
  #   end
  #
  class PackageTask < TaskLib
    # Name of the package (from the GEM Spec).
    attr_accessor :name

    # Version of the package (e.g. '1.3.2').
    attr_accessor :version

    # Directory used to store the package files (default is 'pkg').
    attr_accessor :package_dir

    # True if a gzipped tar file (tgz) should be produced (default is
    # false).
    attr_accessor :need_tar

    # True if a gzipped tar file (tar.gz) should be produced (default
    # is false).
    attr_accessor :need_tar_gz

    # True if a bzip2'd tar file (tar.bz2) should be produced (default
    # is false).
    attr_accessor :need_tar_bz2

    # True if a xz'd tar file (tar.xz) should be produced (default is false)
    attr_accessor :need_tar_xz

    # True if a zip file should be produced (default is false)
    attr_accessor :need_zip

    # List of files to be included in the package.
    attr_accessor :package_files

    # Tar command for gzipped or bzip2ed archives.  The default is 'tar'.
    attr_accessor :tar_command

    # Zip command for zipped archives.  The default is 'zip'.
    attr_accessor :zip_command

    # True if parent directory should be omited (default is false)
    attr_accessor :without_parent_dir

    # Create a Package Task with the given name and version.  Use +:noversion+
    # as the version to build a package without a version or to provide a
    # fully-versioned package name.

    def initialize(name=nil, version=nil)
      init(name, version)
      yield self if block_given?
      define unless name.nil?
    end

    # Initialization that bypasses the "yield self" and "define" step.
    def init(name, version)
      @name = name
      @version = version
      @package_files = Rake::FileList.new
      @package_dir = "pkg"
      @need_tar = false
      @need_tar_gz = false
      @need_tar_bz2 = false
      @need_tar_xz = false
      @need_zip = false
      @tar_command = "tar"
      @zip_command = "zip"
      @without_parent_dir = false
    end

    # Create the tasks defined by this task library.
    def define
      fail "Version required (or :noversion)" if @version.nil?
      @version = nil if :noversion == @version

      desc "Build all the packages"
      task :package

      desc "Force a rebuild of the package files"
      task repackage: [:clobber_package, :package]

      desc "Remove package products"
      task :clobber_package do
        rm_r package_dir rescue nil
      end

      task clobber: [:clobber_package]

      [
        [need_tar, tgz_file, "z"],
        [need_tar_gz, tar_gz_file, "z"],
        [need_tar_bz2, tar_bz2_file, "j"],
        [need_tar_xz, tar_xz_file, "J"]
      ].each do |need, file, flag|
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      gems/gems/rake-13.0.6/lib/rake/file_creation_task.rb                                                0000644                 00000001273 15040313415 0015740 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       m_f f
            safe_ln(fn, f)
          end
        end
      end
      self
    end

    # The name of this package

    def package_name
      @version ? "#{@name}-#{@version}" : @name
    end

    # The directory this package will be built in

    def package_dir_path
      "#{package_dir}/#{package_name}"
    end

    # The package name with .tgz added

    def tgz_file
      "#{package_name}.tgz"
    end

    # The package name with .tar.gz added

    def tar_gz_file
      "#{package_name}.tar.gz"
    end

    # The package name with .tar.bz2 added

    def tar_bz2_file
      "#{package_name}.tar.bz2"
    end

    # The package name with .tar.xz added

    def tar_xz_file
      "#{p                                                                                                                                                                                                                                                                                                                                     gems/gems/rake-13.0.6/lib/rake/invocation_chain.rb                                                  0000644                 00000002276 15040313415 0015432 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       gems/gems/rake-13.0.6/lib/rake/file_creation_task.rb                                                0000644                 00000001273 15040313415 0015740 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true
require "rake/file_task"
require "rake/early_time"

module Rake

  # A FileCreationTask is a file task that when used as a dependency will be
  # needed if and only if the file has not been created.  Once created, it is
  # not re-triggered if any of its dependencies are newer, nor does trigger
  # any rebuilds of tasks that depend on it whenever it is updated.
  #
  class FileCreationTask < FileTask
    # Is this file task needed?  Yes if it doesn't exist.
    def needed?
      !File.exist?(name)
    end

    # Time stamp for file creation task.  This time stamp is earlier
    # than any other time stamp.
    def timestamp
      Rake::EARLY
    end
  end

end
                                                                                                                                                                                                                                                                                                                                     gems/gems/rake-13.0.6/lib/rake/application.rb                                                       0000644                 00000061375 15040313415 0014427 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true
module Rake

  # InvocationChain tracks the chain of task invocations to detect
  # circular dependencies.
  class InvocationChain < LinkedList

    # Is the invocation already in the chain?
    def member?(invocation)
      head == invocation || tail.member?(invocation)
    end

    # Append an invocation to the chain of invocations. It is an error
    # if the invocation already listed.
    def append(invocation)
      if member?(invocation)
        fail RuntimeError, "Circular dependency detected: #{to_s} => #{invocation}"
      end
      conj(invocation)
    end

    # Convert to string, ie: TOP => invocation => invocation
    def to_s
      "#{prefix}#{head}"
    end

    # Class level append.
    def self.append(invocation, chain)
      chain.append(invocation)
    end

    private

    def prefix
      "#{tail} => "
    end

    # Null object for an empty chain.
    class EmptyInvocationChain < LinkedList::EmptyLinkedList
      @parent = InvocationChain

      def member?(obj)
        false
      end

      def append(invocation)
        conj(invocation)
      end

      def to_s
        "TOP"
      end
    end

    EMP